<?php

/**
 * Created by IntelliJ IDEA.
 * User: loic
 * Date: 04/07/2021
 * Time: 16:38
 */

namespace Bloom\CMS\Modules\Conseiller\Http\Controllers;


use Bloom\CMS\Core\Http\Page;
use Bloom\CMS\Modules\Conseiller\Model\Agence;
use Bloom\CMS\Modules\Conseiller\Model\Conseiller;
use Illuminate\Routing\Controller;

class FrontController extends Controller
{

    public function index(Page $page)
    {
        $breadcrumbElements = [["name" => $page->titre, 'url' => '']];
        if ($page->dossier) {
            $dossier = $page->dossier;
            while ($dossier !== null) {
                $breadcrumbElements[] = ['name' => $dossier->name, 'url' => $dossier->full_pathname];
                $dossier = $dossier->parent;
            }
        }

        $breadcrumbElements = array_reverse($breadcrumbElements);

        return view('Conseil::front.index', compact('breadcrumbElements', 'page'));
    }

    public function listing()
    {
        return [
            'agences'      => Agence::published()->get()->load('page'),
            'conseillers' => Conseiller::published()->get()->load('page')
        ];
    }

}
