<?php

/**
 * Created by IntelliJ IDEA.
 * User: loic
 * Date: 21/06/2021
 * Time: 12:21
 */

namespace Bloom\CMS\Modules\Conseiller\Model;

use Bloom\CMS\Core\Contenus\Contenu;
use Bloom\CMS\Core\Contenus\ContenuHandler;
use Bloom\CMS\Core\Contenus\HasStatut;
use Bloom\CMS\Core\Contenus\IsContenu;
use Bloom\CMS\Modules\Conseiller\Geo\Point;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;

/**
 * Class Agence
 * @package Bloom\CMS\Modules\Conseiller\Model
 *
 * @property int    $id
 * @property string $adresse
 * @property string $cp
 * @property string $ville
 * @property int    $rank
 * @property Point  $position
 * @property string $horaires
 * @property string $email
 */
class Agence extends Model implements Contenu
{
    use HasStatut;
    use IsContenu;

    protected $casts = [
        'horaires' => 'array',
    ];

    public function getHandler(): ContenuHandler
    {
        // TODO: Implement getHandler() method.
    }


    public function getPositionAttribute(): Point
    {
        $point = new Point();
        if ($this->exists) {
            $values = DB::table($this->getTable())
                ->selectRaw('X(position) as lat, Y(position) as lng')->where('id', '=', $this->id)->first();
            $point->lat = $values->lat;
            $point->lng = $values->lng;
        }

        return $point;
    }

    public function setPositionAttribute(Point $point)
    {
        if ($point->lng !== null && $point->lat !== null) {
            $this->attributes['position'] = DB::raw(
                "GeomFromText('POINT(" . $point->lat . " " . $point->lng . ")')"
            );
        }
    }
}
