<?php

/**
 * Created by IntelliJ IDEA.
 * User: loic
 * Date: 23/06/2021
 * Time: 11:49
 */

namespace Bloom\CMS\Modules\Conseiller\Http\Controllers;

use Bloom\CMS\Core\Contenus\Statut;
use Bloom\CMS\Core\Helpers\Workflow;
use Bloom\CMS\Core\Http\Controllers\AdminController;
use Bloom\CMS\Core\Http\Dossier;
use Bloom\CMS\Core\Http\Page;
use Bloom\CMS\Modules\Conseiller\Geo\Point;
use Bloom\CMS\Modules\Conseiller\Model\Agence;
use Bloom\CMS\Modules\Conseiller\Model\Conseiller;
use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\View\View;

class AdminAgenceController extends Controller
{

    /**
     * @param Workflow|null $workflow
     * @return View
     */
    public function listing(Workflow $workflow = null)
    {
        if ($workflow === null) {
            // On a pas de workflow donc on est sur /agences
            $workflow = Workflow::query()
                ->where('code', 'like', 'AGENCE%')
                ->orderBy('ordre')
                ->first();
        }

        $controller = new AdminController();
        $view = $controller->listing($workflow);
        $data = $view->getData();
        foreach ($data['all'] as $workflow) {
            $workflow->module->route = "admin_conseil_agences";
        }
        return $view;
    }

    public function edit(Agence $agence)
    {
        $page = $agence->page;
        if (request('dossier_id')) {
            if ($page === null) {
                $page = new Page();
            }
            $page->dossier_id = Dossier::query()->where('type','=',Conseiller::class)->first()->id;
        }

        return view('Conseil::admin.edit_agence', compact('agence', 'page'));
    }

    public function save(Agence $agence)
    {
        $user_id = Auth::user()->getAuthIdentifier();
        $dossier = Dossier::where('type', '=', Conseiller::class)->first();

        if (request('statut_id')) {
            $statut = request('statut_id');
        } elseif ($agence->page !== null) {
            $statut = $agence->page->statut_id ?: Statut::EN_COURS;
        } else {
            $statut = Statut::EN_COURS;
        }

        // Gestion des champs spécifiques aux agences
        $agence->adresse = request('adresse');
        $agence->cp = request('cp');
        $agence->email = request('email');
        $agence->novadial = request('novadial', '');
        $agence->ville = request('ville');
        $agence->position = new Point(request('point_lat'), request('point_lng'));


        //Gestion des horaires
        $days = ['Lundi', 'Mardi', 'Mercredi', 'Jeudi', 'Vendredi', 'Samedi'];
        $hour = ['debut_matin', 'fin_matin', 'debut_am', 'fin_am',];
        $horaires = [];

        for ($i = 0; $i <= 5; $i++) {
            for ($j = 1; $j <= 4; $j++) {
                $horaires[$days[$i]][$hour[$j - 1]] = request('hour0' . ($i) . '_0' . $j) ?: '';
            }
        }

        $agence->horaires = array($horaires);


        if (!$agence->exists) {
            // Nouveau

            // On crée l'agence
            $agence->rank = Agence::all()->count();
            $agence->save();

            // On crée la page
            $page = new Page();
            $page->titre = request('titre');
            $page->slug = request('slug');
            $page->meta_titre = '';
            $page->meta_description = '';
            $page->created_by = $user_id;
            $page->last_modified_by = $user_id;
            $page->intro = request('intro');
            $page->dossier()->associate($dossier);
            $page->to_publish_at = request('date_pub');
            $page->to_unpublish_at = request('date_depub');
            $page->multiplicity = Page::SINGLE;
            $page->image_opengraph = request('vignette');
            $page->mentions = request('mentions');

            if (request('date_pub') && Carbon::createFromFormat('Y-m-d', request('date_pub'))->isAfter(now())) {
                $statut = Statut::EN_COURS;
            }
            if (request('statut_id') == Statut::EN_COURS) {
                $statut = Statut::PUBLIE;
                $page->to_publish_at = now();
            }

            $page->statut_id = $statut;
            // On attache la page et l'article
            $page->contenu()->associate($agence);
            $page->save();
        } else {
            // Edition

            /**
             * @var Page $page
             */
            $page = $agence->page;

            if ($agence->isDirty()) {
                // On mets à jour la page
                $page->last_modified_by = $user_id;
                $agence->save();
            }

            $page->titre = request('titre');
            $page->slug = request('slug');
            $page->intro = request('intro');
            $page->to_publish_at = request('date_pub');
            $page->to_unpublish_at = request('date_depub');
            $page->image_opengraph = request('vignette');
            $page->mentions = request('mentions');

            if (request('date_pub') && Carbon::createFromFormat('Y-m-d', request('date_pub'))->isAfter(now())) {
                $statut = Statut::EN_COURS;
            }
            if (request('statut_id') == Statut::PUBLIE) {
                $statut = Statut::PUBLIE;
                $page->to_publish_at = now();
            }
            $page->statut_id = $statut;

            if ($page->isDirty()) {
                $page->last_modified_by = $user_id;
                $page->save();
                $agence->touch();
            }
        }

        if ($statut == Statut::EN_COURS) {
            return redirect()->route(
                'admin_conseil_agences',
                Workflow::query()->where('code', '=', 'AGENCE_EN_COURS')->first()
            );
        }

        if ($statut == Statut::ARCHIVE) {
            return redirect()->route(
                'admin_conseil_agences',
                Workflow::query()->where('code', '=', 'AGENCE_ARCHIVES')->first()
            );
        }

        return redirect()->route('admin_conseil_agences');
    }

    public function preview(Agence $agence)
    {
        return $agence->getHandler()->single($agence);
    }

    public function publish(Agence $agence)
    {
        /**
         * @var Page $page
         */
        $page = $agence->page;
        $page->publish();

        return redirect()->back();
    }

    public function unpublish(Agence $agence)
    {
        /**
         * @var Page $page
         */
        $page = $agence->page;
        $page->unpublish();

        return redirect()->back();
    }

    public function archive(Agence $agence)
    {
        /**
         * @var Page $page
         */
        $page = $agence->page;
        $page->archive();

        return redirect()->back();
    }

    public function delete(Agence $agence)
    {
        /**
         * @var Page $page
         */
        $page = $agence->page;
        $page->softDelete();

        return redirect()->back();
    }
}
