import slugify from 'slugify';

let form;

// Function to publish and submit the form
window.publishAndSubmit = () => {
  form = $('.main form');

  // If form is not present, wait for the page to finish loading
  if (!form.length) {
    document.addEventListener('readystatechange', publishAndSubmit);
    return;
  }

  let statut = form.find('input[name="statut_id"]').first();

  if (statut.length) {
    statut.val('1');
  } else {
    form.append($('<input name="statut_id" value="1" type="hidden">'));
  }

  form.submit();
}

// Function to handle the change of time elements
function timeChange(group, el) {
  $(group).find('input').prop('required', el.value !== '');
}

// Event listener for when the document's ready state changes
document.addEventListener("readystatechange", () => {
  form = $('.main form');
  let timeElements = $('[class*="wrapper-group"]');

  if (timeElements.length > 0) {
    for (let i = 0; i < timeElements.length; i++) {
      timeElements[i].querySelectorAll('[name^="hour"]').forEach((el) => {
        $(el).change(function (e) {
          timeChange(timeElements[i], e.target);
        });
      });
    }
  }

  // Automatically generate slug from title input
  $('#titre').on('input', function (e) {
    $('#slug').val(slugify(e.target.value, {
      strict: true,
      remove: /[\s!.?]/g
    }));
  });
});