<?php

namespace Bloom\Cms\Configuration;

use Bloom\Cms\Configuration\Facade\ConfigurationsFacade;
use Bloom\Cms\Configuration\Twig\Variables;
use Bloom\CMS\Core\BloomProvider;
use Illuminate\Support\Facades\Schema;

class CmsConfigurationProvider extends BloomProvider
{
    protected $nom = "Configuration";
    protected $code = "configuration";
    protected $icons = "command";

    /**
     * Register services.
     *
     */
    public function register()
    {
        parent::register();
        if (Schema::hasTable('configurations')) {
            $this->app->singleton('site', function () {
                return new ConfigurationsFacade();
            });
        }
    }

    /**
     * Bootstrap services.
     * @return void
     */
    public function boot()
    {
        parent::boot();
        if (Schema::hasTable('configurations')) {
            $config = new Variables();
            $config->load();
        }
    }
}
