<?php


namespace Bloom\Cms\Configuration\Twig;


use Bloom\Cms\Configuration\Data\Configurations;
use Bloom\CMS\Core\Http\Controllers\AdminController;
use Bloom\CMS\Modules\Architecture\Model\Module;


class Variables
{

    public function load()
    {
        //configuration
        $requetes = Configurations::all();
        $array = array();
        foreach ($requetes as $requete) {
            $array+=[$requete->name => $requete->value];
        }

        $request_uri = request()->server->get('REQUEST_URI');

        //liste modules

        $array['modules'] = Module::actif()->get();
        $array['module_actif'] = (new AdminController())->getModuleActif();

        //cookies
        $array['cookietheme'] = array_key_exists('cookietheme', $_COOKIE) ? $_COOKIE['cookietheme'] : 'dark';
        $array['cookienav']   = array_key_exists('cookienav', $_COOKIE) ? $_COOKIE['cookienav'] : 'menu-opened';

        config(['twigbridge.twig.globals' => $array]);
    }
}
