<?php

namespace Bloom\Cms\Configuration\Facade;

use Bloom\Cms\Configuration\Data\Configurations;
use Bloom\Cms\Configuration\Data\GroupeConfigurations;

class ConfigurationsFacade
{
    /**
     * @param string $name
     *
     * @return false|string|null
     */
    public function value(string $name)
    {
        /**
         *@var Configurations $config
         */
        $config = Configurations::where('name', '=', $name)->first();

        return $config ? $config->value : false;
    }

    /**
     * @param string $label
     * @param string $name
     * @param string $groupe
     * @param string|null $value
     * @param string|null $regex
     * @param string|null $retour
     * @param bool $twig
     *
     * @return Configurations|false
     */
    public function config(
        string $label,
        string $name,
        string $groupe,
        string $value = null,
        string $regex = null,
        string $retour = null,
        bool $twig = true
    )
    {
        /**
         *@var Configurations $config
         */
        $config = Configurations::where('name', '=', $name)->first();

        if ($config) {
            return $config;
        } else {
            $config = new Configurations();
            $config->label = $label;
            $config->name = $name;
            $config->value = $value;
            $config->regex = $regex;
            $config->retour = $retour;
            $config->twig = $twig;
            $config->id_groupesConfigurations = $this->getGroupeId($groupe);

            if($config->save()) {
                return $config;
            } else {
                return false;
            }
        }
    }

    /**
     * @param array $configs
     * @param string $groupe
     *
     * @return array
     */
    public function configs(array $configs, string $groupe): array
    {
        $results = array();

        foreach ($configs as $config){
            $response = $this->config(
                $config['label'],
                $config['name'],
                $groupe,
                array_key_exists('value', $config) ? $config['value'] : null,
                array_key_exists('regex', $config) ? $config['regex'] : null,
                array_key_exists('retour', $config) ? $config['retour'] : null,
                array_key_exists('twig', $config)
            );

            array_push($results, $response );
        }

        return $results;
    }

    /**
     * @param string $name
     *
     * @return int
     */
    public function getGroupeId(string $name): int
    {
        /**
         * @var GroupeConfigurations $groupe
         */
        $groupe = GroupeConfigurations::where('nom', '=', $name)->first();

        if(!$groupe) {
            $new_group = new GroupeConfigurations();
            $new_group->nom = $name;
            $new_group->save();
            $group_id = $new_group->id;
        } else {
            $group_id = $groupe->id;
        }

        return $group_id;
    }
}
