<?php

namespace Bloom\Cms\Configuration\Data;


use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;

/**
 * Class Configurations
 * @package Configuration\Data
 *
 * En base
 * @property int         $id
 * @property string      $name
 * @property string      $label
 * @property string|null $value
 * @property string      $id_groupesConfigurations
 * @property string      $regex
 * @property string      $retour
 * @property boolean     $twig
 * @property Carbon      $created_at
 * @property Carbon      $updated_at
 */
class Configurations extends Model
{
    protected $fillable = ['id', 'name','label','value','id_groupesConfigurations','regex','retour', 'twig'];

    public function groupe()
    {
        $this->belongsTo(GroupeConfigurations::class, 'id_groupesConfigurations');
    }

}
