<?php

namespace Bloom\Cms\Configuration;

use Bloom\Cms\Configuration\Data\Configurations;
use Bloom\Cms\Configuration\Facade\ConfigurationsFacade;
use Bloom\CMS\Core\BloomProvider;
use Illuminate\Support\Facades\Schema;
use Twig\Extension\AbstractExtension;
use Twig\Extension\GlobalsInterface;
use TwigBridge\Facade\Twig;


class CmsConfigurationProvider extends BloomProvider
{
    protected $nom = "Configuration";
    protected $code = "configuration";
    protected $icons = "command";

    /**
     * Register services.
     *
     */
    public function register()
    {
        parent::register();
        if (Schema::hasTable('configurations')) {
            $this->app->singleton('site', function () {
                return new ConfigurationsFacade();
            });
        }
    }

    /**
     * Bootstrap services.
     * @return void
     */
    public function boot()
    {
        parent::boot();
        if (Schema::hasTable('configurations')) {
            Twig::addExtension(new class extends AbstractExtension implements GlobalsInterface {
                public function getGlobals(): array
                {
                    $configs = Configurations::where('twig', '=', 1)->get();
                    $array = array();
                    foreach ($configs as $config) {
                        $array += [$config->name => $config->value];
                    }

                    return $array;
                }
            });
        }
    }
}
