<?php


namespace Bloom\Cms\Configuration\Facade;


use Bloom\Cms\Configuration\Data\ConfigurationMenus;
use Bloom\Cms\Configuration\Data\Configurations;
use Bloom\Cms\Configuration\Data\ConfigurationSubmenus;
use Bloom\Cms\Configuration\Data\GroupeConfigurations;
use Bloom\Cms\Configuration\Data\Services;
use Illuminate\Support\Facades\DB;

class ConfigurationsFacade
{

    public function getConfig($name)
    {
        $config = DB::table("configurations")
            ->select("value")
            ->where("name", "=", $name)
            ->first()
            ->value;

        return $config;
    }


    public function createGroupe($names)
    {
        foreach ($names as $name) {
            GroupeConfigurations::firstOrCreate(array(
                "nom" => $name,
            ));
        }
    }

    public function createConfiguration($labels, $names, $values, $groupes, $regex, $retour)
    {
        $compteur = 0;
        foreach ($labels as $label) {
            $id = GroupeConfigurations::where("nom", "=", $groupes[ $compteur ])->first()->id;
            if ($id != null) {
                Configurations::firstOrCreate(array(
                    "label"                    => $label,
                    "name"                     => $names[ $compteur ],
                    "value"                    => $values[ $compteur ],
                    "regex"                    => $regex[ $compteur ],
                    "retour"                    => $retour[ $compteur ],
                    "id_groupesConfigurations" => $id
                ));
                $compteur++;
            }
        }
    }

}
