<?php


namespace Bloom\Cms\Configuration\Facade;


use Bloom\Cms\Configuration\Data\Configurations;
use Bloom\Cms\Configuration\Data\GroupeConfigurations;
use Bloom\Cms\Configuration\Data\Services;
use Illuminate\Support\Facades\DB;

class ConfigurationsFacade
{

    /**
     * @param string $name
     *
     * @return false|string|null
     */
    public function value(string $name)
    {
        /**
         *@var Configurations $config
         */
        $config = Configurations::where('name', '=', $name)->first();

        return $config ? $config->value : false;
    }

    public function getConfig($name)
    {
        $config = DB::table("configurations")
            ->select("value")
            ->where("name", "=", $name)
            ->first()
            ->value ?? null;

        return $config;
    }


    public function createGroupe($names)
    {
        foreach ($names as $name) {
            GroupeConfigurations::firstOrCreate(array(
                "nom" => $name,
            ));
        }
    }

    public function createConfiguration($labels, $names, $values, $groupes, $regex, $retour)
    {
        $compteur = 0;
        foreach ($labels as $label) {
            $id = GroupeConfigurations::where("nom", "=", $groupes[ $compteur ])->first()->id;
            if ($id != null) {
                Configurations::firstOrCreate(array(
                    "label"                    => $label,
                    "name"                     => $names[ $compteur ],
                    "value"                    => $values[ $compteur ],
                    "regex"                    => $regex[ $compteur ],
                    "retour"                    => $retour[ $compteur ],
                    "id_groupesConfigurations" => $id
                ));
                $compteur++;
            }
        }
    }

}
