<?php

namespace Bloom\Cms\Configuration;

use Bloom\Cms\Configuration\Data\Configurations;
use Bloom\Cms\Configuration\Facade\ConfigurationsFacade;
use Bloom\Cms\Configuration\Http\Controllers\ConfigurationController;
use Bloom\Cms\Configuration\Twig\Variables;
use Bloom\Cms\Configuration\Commands\InitProjects;
use Bloom\CMS\Core\BloomProvider;
use Bloom\CMS\Core\Contenus\PageStatique;
use Bloom\CMS\Core\Contenus\Statut;
use Bloom\CMS\Core\Framework\Admin\AdminMenu;
use Bloom\CMS\Core\Http\Dossier;
use Bloom\CMS\Core\Http\Page;
use Bloom\CMS\Modules\Architecture\Model\Module;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Facades\Route;
use Illuminate\Support\Str;

class CmsConfigurationProvider extends BloomProvider
{
    protected $nom = "Configuration";
    protected $code = "configuration";
    /**
     * Register services.
     *
     */
    public function register()
    {
        if ($this->app->runningInConsole()) {
            $this->commands([InitProjects::class]);
        }
        Route::group([
            'middleware' => ['web','auth'],
            'prefix'     => config('app.admin'),
            'namespace'  => 'Bloom\Cms\Configuration\Http\Controllers'],
            function () {
                Route::group(['prefix' => 'configuration'], function () {
                    Route::get('/', 'ConfigurationController@listConfiguration')->name('admin_configuration_index');
                    Route::get('/list', 'ConfigurationController@listConfiguration')->name('configuration_list');
                    Route::post('/list/submit', 'ConfigurationController@editSave')->name('configuration_edit_save');
                });
            }
        );
        $this->loadViewsFrom(dirname(__DIR__) . '/ressources/views', 'ConfigModule');
        $this->loadMigrationsFrom(dirname(__DIR__) . '/database/migrations');

        $this->publishes([
            dirname(__DIR__) . '/public/build' => public_path('/vendor/cms-module-configuration')
        ], 'assets');


        if (Schema::hasTable('configurations')) {
            $this->app->singleton('site', function () {
                return new ConfigurationsFacade();
            });
        }

    }


    /**
     * Bootstrap services.
     * @return void
     */
    public function boot()
    {
        parent::boot();

        self::getModule();
        if (Schema::hasTable('configurations')) {
            $config = new Variables();
            $config->load();
        };
        $this->addSubMenus([
            new AdminMenu([
                'label'  => 'Configuration',
                'route'  => 'admin_configuration_index',
            ])
        ]);

    }

}
