<?php


namespace Bloom\Cms\Configuration\Http\Controllers;



use Bloom\Cms\Configuration\Data\Configurations;
use Bloom\Cms\Configuration\Data\GroupeConfigurations;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\{Log, Session, DB};
use Mockery\Exception;


class ConfigurationController extends Controller
{
    public function index()
    {
        $configurations = Configurations::all();
        $groupesConfigurations = GroupeConfigurations::all();

        return view("Configuration::liste_config", compact("configurations", "groupesConfigurations"));
    }

    public function save(Request $request)
    {
        $configurations = Configurations::all();
        try {
            foreach ($configurations as $configuration) {
                DB::table('configurations')->where("name", $configuration->name)->update(['value' => $request[ $configuration->name ]]);
            }
            Session::flash('message', 'L\'enregistrement s\'est bien déroulé');
        } catch (Exception $e) {
            Session::flash('error', 'Une erreur est survenue lors de l\'enregistrement.');
            Log::error($e->getMessage());
        }

        return back();
    }
}
