@extends('bloom.layout.admin')

@section('assets')
    @vite('ressources/assets/js/configuration.js', 'vendor/cms-module-configuration')
@endsection

@section('content')
    <div class="container-fluid">
        <div id="navbar-btns" class="mb-5 heading-text d-flex justify-content-between align-items-center sticky-top">
            <h1>Configurations</h1>
            <span>
            <button class="btn btn-grisclair5 btn-primary btn_click">
                Valider
            </button>
        </span>
        </div>

        <div class="content">
            <form method="post" action="{{ route("configuration_edit_save") }}" id="myform">
                <div class="form-group row mb-0">

                    @foreach($groupesConfigurations as $groupesConfiguration)
                        <div class="col-12 mb-4">
                            <legend>{{ $groupesConfiguration->nom }}</legend>
                            @foreach($configurations as $configuration)
                                @if($groupesConfiguration->id === $configuration->id_groupesConfigurations)
                                    <div class="col-6">
                                        <label class="control-label"
                                               for="{{ $configuration->name }}">{{ $configuration->label }}</label>
                                        <div>
                                            <input type="text" class="form-control input mb-2"
                                                   id="{{ $configuration->name }}"
                                                   data-regex="{{ $configuration->regex }}"
                                                   data-retour="{{ $configuration->retour }}"
                                                   name="{{ $configuration->name }}"
                                                   pattern="{{ $configuration->regex }}"
                                                   value="{{ $configuration->value }}">
                                            <div class="retour"></div>
                                        </div>
                                    </div>
                                @endif
                            @endforeach
                        </div>
                    @endforeach
                </div>
                {{ csrf_field() }}
            </form>
        </div>
    </div>
@endsection