<?php
/**
 *  * Created by : Jérôme Bonnier
 * Created at : 23/04/2021
 *
 * In : PhpStorm
 */

namespace Unit;

use Bloom\CMS\Core\Test;
use Bloom\Cms\Configuration\{CmsConfigurationProvider, Data\Configurations, Data\GroupeConfigurations, Facade\Site};
use Illuminate\Support\Str;


class ConfigTest extends Test
{
    protected $provider = CmsConfigurationProvider::class;

    /**
     * @test
     */
    public function test_should_create_config() {
        $config = Site::config(
            Str::random(),
            Str::random(),
            Str::random()
        );

        $this->assertDatabaseHas('configurations', [
            'label'                     => $config->label,
            'name'                      => $config->name,
            'value'                     => $config->value,
            'regex'                     => $config->regex,
            'retour'                    => $config->retour,
            'id_groupesConfigurations'  => $config->id_groupesConfigurations,
        ]);

    }

    /**
     * @test
     */
    public function test_should_create_multiple_config() {
        $configs = [];
        $array = array(Str::random(), null);
        for ($i=0; $i<rand(2,6); $i++) {
            array_push($configs,
                [
                'label'     => Str::random(),
                'name'      => Str::random(),
                'value'     => $array[array_rand($array)],
                'regex'     => $array[array_rand($array)],
                'retour'    => $array[array_rand($array)],
                'twig'      => array_rand([false, true]),
                ]);
        }

        $groupe_name = Str::random();
        $results = Site::configs($configs, $groupe_name);

        for ($i=0; $i<count($results); $i++) {
            $this->assertDatabaseHas('configurations',
                [
                'label'                     => $results[$i]->label,
                'name'                      => $results[$i]->name,
                'value'                     => $results[$i]->value,
                'regex'                     => $results[$i]->regex,
                'retour'                    => $results[$i]->retour,
                'twig'                      => $results[$i]->twig,
                'id_groupesConfigurations'  => GroupeConfigurations::where('nom', '=', $groupe_name)->first()->id,
                ]);
        }

        $this->assertDatabaseHas('groupe_configurations',
            [
                'nom' => $groupe_name
            ]);

    }

}