<?php

namespace Bloom\Cms\Configuration;

use Bloom\Cms\Configuration\Facade\ConfigurationsFacade;
use Bloom\Cms\Configuration\Twig\Variables;
use Bloom\Cms\Configuration\Commands\InitProjects;
use Bloom\CMS\Modules\Architecture\Model\Module;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Facades\Route;

class CmsConfigurationProvider extends ServiceProvider
{
    /**
     * Register services.
     *
     */
    public function register()
    {
        if ($this->app->runningInConsole()) {
            $this->commands([InitProjects::class]);
        }
        Route::group([
            'middleware' => ['web','auth'],
            'prefix'     => config('app.admin'),
            'namespace'  => 'Bloom\Cms\Configuration\Http\Controllers'],
            function () {
                Route::group(['prefix' => 'configuration'], function () {
                    Route::get('/list', 'ConfigurationController@listConfiguration')->name('configuration_list');
                    Route::post('/list/submit', 'ConfigurationController@editSave')->name('configuration_edit_save');
                });
            }
        );
        $this->loadViewsFrom(dirname(__DIR__) . '/ressources/views', 'ConfigModule');
        $this->loadMigrationsFrom(dirname(__DIR__) . '/database/migrations');
        $this->publishes([
            dirname(__DIR__) . '/ressources/mix' => public_path('/vendor/cms-module-configuration'),
        ], 'assets');


        if (Schema::hasTable('configurations')) {
            $this->app->singleton('site', function () {
                return new ConfigurationsFacade();
            });
        }

    }

    public static function getModule()
    {
        if (Schema::hasTable('modules')) {
            $module = Module::nom('configurations')->firstOrCreate([
                'nom'        => 'configurations',
                'nom_public' => 'Configurations',
                'route'      => 'configuration_list',
            ]);
            if (!$module->exists) {
                $module->active = 1;
                $module->save();
            }

            return $module;
        }

        return false;
    }

    /**
     * Bootstrap services.
     * @return void
     */
    public function boot()
    {
        self::getModule();
        if (Schema::hasTable('configurations')) {
            $config = new Variables();
            $config->load();
        };

    }
}
