<?php

namespace Database\Seeders;
use Carbon\Carbon;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class ConfigurationTableSeeder extends Seeder
{
    /**
     * Run the database seeders.
     *
     * @return void
     */
    public function run()
    {

        DB::table('configurations')->insert([
            [
                'id'                       => 1,
                'name'                     => "societe",
                'label'                    => "Société ou site",
                'value'                    => "société",
                'id_groupesConfigurations' => 1,
                'regex'                    => "^([0-9a-zA-Z-àá\sâäòóôöèéêëçìíîïùúûüÿ'])+$",
                'retour'                    => "Seuls les caractères alphabétiques sont autorisés.",
                'created_at'               => Carbon::now(),
                'updated_at'               => Carbon::now(),
            ],
            [
                'id'                       => 2,
                'name'                     => "adresse",
                'label'                    => "Adresse",
                'value'                    => "adresse",
                'id_groupesConfigurations' => 2,
                'regex'                    => "",
                'retour'                    => "",
                'created_at'               => Carbon::now(),
                'updated_at'               => Carbon::now(),
            ],
            [
                'id'                       => 3,
                'name'                     => "ville",
                'label'                    => "Ville",
                'value'                    => "ville",
                'id_groupesConfigurations' => 2,
                'regex'                    => "^([a-zA-Z-àá\sâäòóôöèéêëçìíîïùúûüÿ'])+$",
                'retour'                    => "Seuls les caractères alphabétiques sont autorisés.",
                'created_at'               => Carbon::now(),
                'updated_at'               => Carbon::now(),
            ],
            [
                'id'                       => 4,
                'name'                     => "cp",
                'label'                    => "Code postal",
                'value'                    => "cp",
                'id_groupesConfigurations' => 2,
                'regex'                    => "^\d{5}$",
                'retour'                    => "Format XXXXX attendu.",
                'created_at'               => Carbon::now(),
                'updated_at'               => Carbon::now(),
            ],
            [
                'id'                       => 5,
                'name'                     => "pays",
                'label'                    => "Pays",
                'value'                    => "pays",
                'id_groupesConfigurations' => 2,
                'regex'                    => "^([a-zA-Z-àá\sâäòóôöèéêëçìíîïùúûüÿ'])+$",
                'retour'                    => "Seuls les caractères alphabétiques sont autorisés.",
                'created_at'               => Carbon::now(),
                'updated_at'               => Carbon::now(),
            ],
            [
                'id'                       => 6,
                'name'                     => "tel",
                'label'                    => "Téléphone",
                'value'                    => "tel",
                'id_groupesConfigurations' => 3,
                'regex'                    => "^(0|\+33)[1-9]([-. ]?[0-9]{2}){4}$",
                'retour'                    => "Erreur de format de téléphone.",
                'created_at'               => Carbon::now(),
                'updated_at'               => Carbon::now(),
            ],
            [
                'id'                       => 7,
                'name'                     => "num_vert",
                'label'                    => "N° vert/azur",
                'value'                    => "num_vert",
                'id_groupesConfigurations' => 4,
                'regex'                    => "^(0|\+33)[1-9]([-. ]?[0-9]{2}){4}$",
                'retour'                    => "Erreur de format de téléphone.",
                'created_at'               => Carbon::now(),
                'updated_at'               => Carbon::now(),
            ],
            [
                'id'                       => 8,
                'name'                     => "url_publique",
                'label'                    => "URL publique",
                'value'                    => "url_publique",
                'id_groupesConfigurations' => 5,
                'regex'                    => "[(http(s)?):\/\/(www\.)?a-zA-Z0-9@:%._\+~#=]{2,256}\.[a-z]{2,6}\b([-a-zA-Z0-9@:%_\+.~#?&//=]*)",
                'retour'                    => "Erreur de format de l'url.",
                'created_at'               => Carbon::now(),
                'updated_at'               => Carbon::now(),
            ],
            [
                'id'                       => 9,
                'name'                     => "adresse_rgpd",
                'label'                    => "Adresse",
                'value'                    => "adresse_rgpd",
                'id_groupesConfigurations' => 6,
                'regex'                    => "",
                'retour'                    => "",
                'created_at'               => Carbon::now(),
                'updated_at'               => Carbon::now(),
            ],
            [
                'id'                       => 10,
                'name'                     => "ville_rgpd",
                'label'                    => "Ville",
                'value'                    => "ville_rgpd",
                'id_groupesConfigurations' => 6,
                'regex'                    => "^([a-zA-Z-àá\sâäòóôöèéêëçìíîïùúûüÿ'])+$",
                'retour'                    => "Seuls les caractères alphabétiques sont autorisés.",
                'created_at'               => Carbon::now(),
                'updated_at'               => Carbon::now(),
            ],
            [
                'id'                       => 11,
                'name'                     => "cp_rgpd",
                'label'                    => "Code postal",
                'value'                    => "cp_rgpd",
                'id_groupesConfigurations' => 6,
                'regex'                    => "^\d{5}$",
                'retour'                    => "Format XXXXX attendu.",
                'created_at'               => Carbon::now(),
                'updated_at'               => Carbon::now(),
            ],
            [
                'id'                       => 12,
                'name'                     => "pays_rgpd",
                'label'                    => "Pays",
                'value'                    => "pays_rgpd",
                'id_groupesConfigurations' => 6,
                'regex'                    => "^([a-zA-Z-àá\sâäòóôöèéêëçìíîïùúûüÿ'])+$",
                'retour'                    => "Seuls les caractères alphabétiques sont autorisés.",
                'created_at'               => Carbon::now(),
                'updated_at'               => Carbon::now(),
            ],

        ]);
        DB::table('groupe_configurations')->insert([
            [
                'id'         => 1,
                'nom'        => "Identification",
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now(),
            ],
            [
                'id'         => 2,
                'nom'        => "Coordonnées postales",
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now(),
            ],
            [
                'id'         => 3,
                'nom'        => "Coordonnées téléphoniques",
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now(),
            ],
            [
                'id'         => 4,
                'nom'        => "N° spéciaux",
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now(),
            ],
            [
                'id'         => 5,
                'nom'        => "URL",
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now(),
            ],
            [
                'id'         => 6,
                'nom'        => "Coordonnées RGPD",
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now(),
            ],
        ]);
    }
}
