<?php


namespace Bloom\Cms\Configuration\Http\Controllers;



use Bloom\Cms\Configuration\Data\Configurations;
use Bloom\Cms\Configuration\Data\GroupeConfigurations;
use Bloom\Cms\Sites\Helpers\SiteHelper;
use Bloom\Cms\Sites\Repository\Eloquent\SiteRepository;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\{Log, Session, DB};
use Mockery\Exception;


class ConfigurationController extends Controller
{
    public function index(SiteRepository $siteRepository)
    {
        $site_id = request('site');
        $sites = $siteRepository->getEnLigne();
        $configurations = Configurations::where('site_id', '=', $site_id)->get();
        $groupesConfigurations = GroupeConfigurations::all();

        return view("Configuration::liste_config", compact("configurations", "groupesConfigurations", "sites", "site_id"));
    }

    public function save(Request $request)
    {
        $configurations = Configurations::all();
        try {
            foreach ($configurations as $configuration) {
                DB::table('configurations')->where("name", $configuration->name)
                    ->where('site_id', '=', $request['site_id'])
                    ->update([
                        'value' => $request[ $configuration->name ],
                    ]);
            }
            Session::flash('message', 'L\'enregistrement s\'est bien déroulé');
        } catch (Exception $e) {
            Session::flash('error', 'Une erreur est survenue lors de l\'enregistrement.');
            Log::error($e->getMessage());
        }

        return back();
    }
}
