<?php


use Carbon\Carbon;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class ConfigurationTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $groupIdent = DB::table('groupe_configurations')->insertGetId(
            [
                'nom'        => "Identification",
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now(),
            ]
        );
        $groupCp = DB::table('groupe_configurations')->insertGetId(
            [
                'nom'        => "Coordonnées postales",
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now(),
            ]
        );
        $groupTel = DB::table('groupe_configurations')->insertGetId(
            [
                'nom'        => "Coordonnées téléphoniques",
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now(),
            ]
        );
        $groupTelSpec = DB::table('groupe_configurations')->insertGetId(
            [
                'nom'        => "N° spéciaux",
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now(),
            ]
        );
        $groupurl = DB::table('groupe_configurations')->insertGetId(
            [
                'nom'        => "URL",
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now(),
            ]
        );
        $groupRgpd = DB::table('groupe_configurations')->insertGetId(
            [
                'nom'        => "Coordonnées RGPD",
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now(),
            ]
        );
        DB::table('configurations')->insert(
            [
                [
                    'name'                     => "societe",
                    'label'                    => "Société ou site",
                    'value'                    => "Nom du site",
                    'id_groupesConfigurations' => $groupIdent,
                    'regex'                    => "^([0-9a-zA-Z-àá\sâäòóôöèéêëçìíîïùúûüÿ'])+$",
                    'retour'                   => "Seuls les caractères alphabétiques sont autorisés.",
                    'created_at'               => Carbon::now(),
                    'updated_at'               => Carbon::now(),
                ],
                [
                    'name'                     => "icons",
                    'label'                    => "Icons",
                    'value'                    => "/images/admin/logo_default.png",
                    'id_groupesConfigurations' => $groupIdent,
                    'regex'                    => "",
                    'retour'                   => "",
                    'created_at'               => Carbon::now(),
                    'updated_at'               => Carbon::now(),
                ],
                [
                    'name'                     => "adresse",
                    'label'                    => "Adresse",
                    'value'                    => "",
                    'id_groupesConfigurations' => $groupCp,
                    'regex'                    => "",
                    'retour'                   => "",
                    'created_at'               => Carbon::now(),
                    'updated_at'               => Carbon::now(),
                ],
                [
                    'name'                     => "ville",
                    'label'                    => "Ville",
                    'value'                    => "",
                    'id_groupesConfigurations' => $groupCp,
                    'regex'                    => "^([a-zA-Z-àá\sâäòóôöèéêëçìíîïùúûüÿ'])+$",
                    'retour'                   => "Seuls les caractères alphabétiques sont autorisés.",
                    'created_at'               => Carbon::now(),
                    'updated_at'               => Carbon::now(),
                ],
                [
                    'name'                     => "cp",
                    'label'                    => "Code postal",
                    'value'                    => "",
                    'id_groupesConfigurations' => $groupCp,
                    'regex'                    => "^\d{5}$",
                    'retour'                   => "Format XXXXX attendu.",
                    'created_at'               => Carbon::now(),
                    'updated_at'               => Carbon::now(),
                ],
                [
                    'name'                     => "pays",
                    'label'                    => "Pays",
                    'value'                    => "",
                    'id_groupesConfigurations' => $groupCp,
                    'regex'                    => "^([a-zA-Z-àá\sâäòóôöèéêëçìíîïùúûüÿ'])+$",
                    'retour'                   => "Seuls les caractères alphabétiques sont autorisés.",
                    'created_at'               => Carbon::now(),
                    'updated_at'               => Carbon::now(),
                ],
                [
                    'name'                     => "tel",
                    'label'                    => "Téléphone",
                    'value'                    => "",
                    'id_groupesConfigurations' => $groupTel,
                    'regex'                    => "^(0|\+33)[1-9]([-. ]?[0-9]{2}){4}$",
                    'retour'                   => "Erreur de format de téléphone.",
                    'created_at'               => Carbon::now(),
                    'updated_at'               => Carbon::now(),
                ],
                [
                    'name'                     => "num_vert",
                    'label'                    => "N° vert/azur",
                    'value'                    => "",
                    'id_groupesConfigurations' => $groupTelSpec,
                    'regex'                    => "^(0|\+33)[1-9]([-. ]?[0-9]{2}){4}$",
                    'retour'                   => "Erreur de format de téléphone.",
                    'created_at'               => Carbon::now(),
                    'updated_at'               => Carbon::now(),
                ],
                [
                    'name'                     => "url_publique",
                    'label'                    => "URL publique",
                    'value'                    => "",
                    'id_groupesConfigurations' => $groupurl,
                    'regex'                    => "[(http(s)?):\/\/(www\.)?a-zA-Z0-9@:%._\+~#=]{2,256}\.[a-z]{2,6}\b([-a-zA-Z0-9@:%_\+.~#?&//=]*)",
                    'retour'                   => "Erreur de format de l'url.",
                    'created_at'               => Carbon::now(),
                    'updated_at'               => Carbon::now(),
                ],
                [
                    'name'                     => "adresse_rgpd",
                    'label'                    => "Adresse",
                    'value'                    => "",
                    'id_groupesConfigurations' => $groupRgpd,
                    'regex'                    => "",
                    'retour'                   => "",
                    'created_at'               => Carbon::now(),
                    'updated_at'               => Carbon::now(),
                ],
                [
                    'name'                     => "ville_rgpd",
                    'label'                    => "Ville",
                    'value'                    => "",
                    'id_groupesConfigurations' => $groupRgpd,
                    'regex'                    => "^([a-zA-Z-àá\sâäòóôöèéêëçìíîïùúûüÿ'])+$",
                    'retour'                   => "Seuls les caractères alphabétiques sont autorisés.",
                    'created_at'               => Carbon::now(),
                    'updated_at'               => Carbon::now(),
                ],
                [
                    'name'                     => "cp_rgpd",
                    'label'                    => "Code postal",
                    'value'                    => "",
                    'id_groupesConfigurations' => $groupRgpd,
                    'regex'                    => "^\d{5}$",
                    'retour'                   => "Format XXXXX attendu.",
                    'created_at'               => Carbon::now(),
                    'updated_at'               => Carbon::now(),
                ],
                [
                    'name'                     => "pays_rgpd",
                    'label'                    => "Pays",
                    'value'                    => "",
                    'id_groupesConfigurations' => $groupRgpd,
                    'regex'                    => "^([a-zA-Z-àá\sâäòóôöèéêëçìíîïùúûüÿ'])+$",
                    'retour'                   => "Seuls les caractères alphabétiques sont autorisés.",
                    'created_at'               => Carbon::now(),
                    'updated_at'               => Carbon::now(),
                ],
            ]
        );
    }
}
