<?php


namespace Bloom\Cms\Configuration\Twig;


use Bloom\Cms\Configuration\Data\Configurations;
use Bloom\CMS\Modules\Architecture\Model\Module;


class Variables
{

    public function load()
    {
        //configuration
        $requetes = Configurations::all();
        $array = array();
        foreach ($requetes as $requete) {
            $array+=[$requete->name => $requete->value];
        }

        $request_uri = request()->server->get('REQUEST_URI');

        //liste modules
        $array['modules'] = Module::actif()->get();
        foreach ( $array['modules'] as $module) {
            $module['subMenus'] =$module->subMenus()->get();

            if(str_contains($request_uri, $module->nom)){
                $array['module_actif'] = $module->id;
            }
        }

        //cookies
        $array['cookietheme'] = array_key_exists('cookietheme', $_COOKIE) ? $_COOKIE['cookietheme'] : 'dark';
        $array['cookienav']   = array_key_exists('cookienav', $_COOKIE) ? $_COOKIE['cookienav'] : 'menu-opened';

        config(['twigbridge.twig.globals' => $array]);
    }
}
