<?php


namespace Bloom\Cms\Configuration\Twig;

use Bloom\Cms\Configuration\Data\Configurations;
use Twig\Extension\AbstractExtension;
use Twig\Extension\GlobalsInterface;
use TwigBridge\Facade\Twig;

/**
 * Class Variables
 * @package Bloom\Cms\Configuration\Twig
 */
class Variables
{

    public function load()
    {
        Twig::addExtension(new class extends AbstractExtension implements GlobalsInterface {
            /**
             * @inheritDoc
             */
            public function getGlobals()
            {
                $requetes = Configurations::all();
                $array = array();
                foreach ($requetes as $requete) {
                    $array += [$requete->name => $requete->value];
                }

                return $array;
            }
        });
    }
}
