<?php

namespace Bloom\Cms\Concession\Repository\Eloquent;

use Bloom\Cms\Concession\Models\Service;
use Bloom\Cms\Concession\Repository\ServiceRepositoryInterface;
use Bloom\CMS\Core\Contenus\Statut;
use Bloom\Cms\Concession\Repository\Eloquent\BaseRepository;
use Illuminate\Support\Collection;

class ServiceRepository extends BaseRepository implements ServiceRepositoryInterface
{

    public function __construct(Service $model)
    {
        parent::__construct($model);
    }

    public function all(): Collection
    {
        return $this->model->all();
    }

    public function getPublished(int $concession_id, bool $count = false)
    {
        $query = $this->model
            ->where('statut_id', Statut::PUBLIE)
            ->where('concession_id', $concession_id)
        ;

        if ($count) {
            return $query->count();
        } else {
            return $query->get();
        }
    }

    public function getEncours(int $concession_id, bool $count = false)
    {
        $query = $this->model
            ->where('statut_id', Statut::EN_COURS)
            ->where('concession_id', $concession_id)
            ->orderBy('updated_at', 'DESC')
        ;

        if ($count) {
            return $query->count();
        } else {
            return $query->get();
        }
    }

    public function getArchived(int $concession_id, bool $count = false)
    {
        $query = $this->model
            ->where('statut_id', Statut::ARCHIVE)
            ->where('concession_id', $concession_id)
            ->orderBy('updated_at', 'DESC')
        ;

        if ($count) {
            return $query->count();
        } else {
            return $query->get();
        }
    }
}
