<?php

namespace Bloom\Cms\Concession\Models;

use Bloom\CMS\Core\Contenus\Statut;
use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Foundation\Auth\User;

/**
 * class Service
 * @package Bloom\Cms\Concession\Models
 *
 * @property string    $nom
 * @property boolean   $sav
 * @property string    $visuel
 * @property string    $horaires
 * @property string    $telephone
 * @property string    $fax
 * @property string    $description
 * @property integer   $statut_id
 * @property integer   $concession_id
 * @property integer   $created_by
 * @property integer   $updated_by
 */
class Service extends Model
{

    protected $table = 'concession_services';

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'nom',
        'sav',
        'visuel',
        'horaires',
        'telephone',
        'fax',
        'description',
        'concession_id',
        'created_by',
        'updated_by',
    ];

    /**
     * The attributes that should be hidden for arrays.
     *
     * @var array
     */
    protected $hidden = [
        'created_at',
        'updated_at',
    ];

    public function cree_par(): BelongsTo
    {
        return $this->belongsTo(User::class, 'created_by');
    }

    public function derniere_modification_par(): BelongsTo
    {
        return $this->belongsTo(User::class, 'updated_by');
    }

    public function concession()
    {
        return $this->belongsTo(Concession::class);
    }
}
