<?php

namespace Bloom\Cms\Concession\Models;

use Bloom\Cms\Sites\Models\Site;
use Illuminate\Database\Eloquent\Model;

/**
 * class Concession
 * @package Bloom\Cms\Concession\Models
 *
 * @property string    $nom_public
 * @property string    $telephone
 * @property string    $fax
 * @property string    $coord_gps
 * @property string    $visuel
 * @property string    $horaires
 * @property string    $description
 * @property integer   $site_id
 * @property string    $code_concession
 * @property string    $mentions_legales
 * @property string    $knave_id
 */
class Concession extends Model
{

    protected $table = 'concession';

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'nom_public',
        'telephone',
        'fax',
        'coord_gps',
        'visuel',
        'horaires',
        'description',
        'site_id',
        'code_concession',
        'mentions_legales',
        'knave_id',
    ];

    /**
     * The attributes that should be hidden for arrays.
     *
     * @var array
     */
    protected $hidden = [
        'created_at',
        'updated_at',
    ];

    public function site()
    {
        return $this->belongsTo(Site::class);
    }

    public function membres()
    {
        return $this->hasMany(Membre::class);
    }

    public function services()
    {
        return $this->hasMany(Service::class);
    }

    public function getKnaveUrlAttribute(): ?string
    {
        if ($this->knave_id) {
            return config('knave.url') . $this->knave_id;
        }
        return null;
    }

}
