<?php

use Bloom\Cms\Concession\Http\Controllers\ConcessionController;
use Illuminate\Support\Facades\Route;

Route::get('/', [ConcessionController::class, 'index'])->name('index');
Route::get('/edit/{concession?}', [ConcessionController::class, 'edit'])->name('edit');
Route::post('/edit/{concession?}', [ConcessionController::class, 'save'])->name('save');

Route::get('/services/{concession}', [ConcessionController::class, 'services_index'])->name('services_index');
Route::get('/services/{concession}/edit/{service?}', [ConcessionController::class, 'services_edit'])->name('services_edit');
Route::post('/services/edit/{service?}', [ConcessionController::class, 'services_save'])->name('services_save');
Route::get('/services/{service}/publish', [ConcessionController::class, 'services_publish'])->name('services_publish');
Route::get('/services/{service}/unpublish', [ConcessionController::class, 'services_unpublish'])->name('services_unpublish');
Route::get('/services/{service}/archive', [ConcessionController::class, 'services_archive'])->name('services_archive');
Route::get('/services/{service}/unarchive', [ConcessionController::class, 'services_unarchive'])->name('services_unarchive');
Route::get('/services/{service}/delete', [ConcessionController::class, 'services_delete'])->name('services_delete');

Route::get('/membres/{concession}', [ConcessionController::class, 'membres_index'])->name('membres_index');
Route::get('/membres/{concession}/edit/{membre?}', [ConcessionController::class, 'membres_edit'])->name('membres_edit');
Route::post('/membres/edit/{membre?}', [ConcessionController::class, 'membres_save'])->name('membres_save');
Route::get('/membres/{membre}/publish', [ConcessionController::class, 'membres_publish'])->name('membres_publish');
Route::get('/membres/{membre}/unpublish', [ConcessionController::class, 'membres_unpublish'])->name('membres_unpublish');
Route::get('/membres/{membre}/archive', [ConcessionController::class, 'membres_archive'])->name('membres_archive');
Route::get('/membres/{membre}/unarchive', [ConcessionController::class, 'membres_unarchive'])->name('membres_unarchive');
Route::get('/membres/{membre}/delete', [ConcessionController::class, 'membres_delete'])->name('membres_delete');
