<?php

use Bloom\Cms\Concession\Models\Concession;
use Bloom\Cms\Concession\Models\Membre;
use Bloom\Cms\Concession\Models\Service;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class UpdateAddConcessionId extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('concession_membres', function (Blueprint $table) {
            $table->integer('concession_id');
        });
        Schema::table('concession_services', function (Blueprint $table) {
            $table->integer('concession_id');
        });

        $concession = Concession::first();
        $membres = Membre::all();
        foreach ($membres as $membre) {
            $membre->concession_id = $concession->id;
            $membre->save();
        }
        $services = Service::all();
        foreach ($services as $service) {
            $service->concession_id = $concession->id;
            $service->save();
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('concession', function (Blueprint $table) {
            //
        });
    }
}
