<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateServicesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('concession_services', function (Blueprint $table) {
            $table->id();
            $table->string('nom', 45);
            $table->boolean('sav')->nullable();
            $table->string('visuel');
            $table->text('horaires');
            $table->string('telephone', 12);
            $table->string('fax', 12)->nullable();
            $table->text('description')->nullable();
            $table->integer('statut_id');
            $table->integer('created_by');
            $table->integer('updated_by');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('offres');
    }
}
