<?php

/**
 * Created by IntelliJ IDEA.
 * User: loic
 * Date: 07/12/2020
 * Time: 11:59
 */

namespace Bloom\CMS\HPV\Cliniques\Http\Controllers;

use Bloom\CMS\Core\Contenus\Statut;
use Bloom\CMS\Core\Helpers\Workflow;
use Bloom\CMS\HPV\Cliniques\Model\Clinique;
use Bloom\CMS\HPV\Cliniques\Model\Telephone;
use Grimzy\LaravelMysqlSpatial\Types\Point;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\Log;

class AdminController extends Controller
{
    public function edit(Clinique $clinique)
    {
        $telephones = [];

        if (!empty($clinique->telephone)) {
            $telephones = $this->checkTelephonesIsEmpty($clinique->telephone);
        } else {
            $telephone['libelle'] = '';
            $telephone['value'] = '';
            $telephones[] = $telephone;
        }

        $clinique->telephone = $telephones;

        return view('Clinique::admin.edit', compact('clinique'));
    }

    public function checkTelephonesIsEmpty(array $telephones): array
    {
        $newTelephones = [];

        foreach ($telephones as $telephone) {
            if ($telephone['libelle'] != '') {
                $newTelephones[] = $telephone;
            }
        }
        return $newTelephones;
    }

    public function save(Clinique $clinique)
    {
        $clinique->nom = request('nom');
        $clinique->adresse = request('adresse');
        $clinique->cp = request('cp');
        $clinique->ville = request('ville');
        $clinique->telephone = $this->checkTelephonesIsEmpty(json_decode(request('values', '[]'), true));
        $clinique->fax = request('fax', '');
        $clinique->doctolib = request('doctolib');
        $clinique->vignette = request('vignette');
        $clinique->transport = request('transport');
        $clinique->description = request('description');
        $clinique->position = new Point(request('point_lat'), request('point_lng'));
        $clinique->statut_id = request('statut_id', Statut::EN_COURS);
        $clinique->save();

        if ((int)$clinique->statut_id === Statut::PUBLIE) {
            return redirect()->route('admin_clinique_index');
        }

        $workflow = Workflow::query()->where('code', '=', 'CLINIQUE_EN_COURS')->first();

        return redirect()->route('admin_clinique_index', $workflow);
    }

    //#region Actions

    public function preview(Clinique $clinique)
    {
        Log::debug("Loading clinique preview", compact('clinique'));
        $cliniques = Clinique::query()->whereIn('statut_id', [Statut::PUBLIE, Statut::EN_COURS])->get();

        return view('Clinique::front.index', compact('cliniques'));
    }
    
    public function publish(Clinique $clinique)
    {
        $clinique->statut_id = Statut::PUBLIE;
        $clinique->to_publish_at = now();
        $clinique->save();

        return redirect()->back();
    }

    public function unpublish(Clinique $clinique)
    {
        $clinique->statut_id = Statut::EN_COURS;
        $clinique->to_unpublish_at = now();
        $clinique->save();

        return redirect()->back();
    }

    public function archive(Clinique $clinique)
    {
        $clinique->statut_id = Statut::ARCHIVE;
        $clinique->to_unpublish_at = now();
        $clinique->save();

        return redirect()->back();
    }

    public function duplicate(Clinique $clinique)
    {
        $dub = $clinique->replicate(['created_at', 'updated_at', 'created_by', 'last_modified_by']);
        $dub->nom = $clinique->nom . ' - Copie';
        // L’entité dupliquée prend le statut ‘en cours’
        $dub->statut_id = Statut::EN_COURS;
        $dub->to_publish_at = null;
        $dub->to_unpublish_at = null;
        $dub->save();
        // Ouverture de l’onglet/workflow ‘en cours’
        $workflow = Workflow::query()->where('code', '=', 'CLINIQUE_EN_COURS')->first();

        return redirect()->route('admin_clinique_index', $workflow);
    }

    public function delete(Clinique $clinique)
    {
        $clinique->statut_id = Statut::SUPPRIMER;
        $clinique->save();

        return redirect()->back();
    }
    //#endregion
}
