<?php

/**
 * Created by IntelliJ IDEA.
 * User: loic
 * Date: 14/12/2020
 * Time: 15:23
 */

namespace Bloom\CMS\HPV\Cliniques\Http\Controllers;

use Bloom\CMS\Core\Contenus\Statut;
use Bloom\CMS\Core\Http\Page;
use Bloom\CMS\HPV\Cliniques\Model\Clinique;
use Illuminate\Routing\Controller;

class FrontController extends Controller
{
    public function index(Page $page)
    {
        $cliniques = Clinique::query()->where('statut_id', '=', Statut::PUBLIE)->get();

        $breadcrumbElements = [["name" => $page->titre, 'url' => '']];
        if ($page->dossier) {
            $dossier = $page->dossier;
            while ($dossier !== null) {
                $breadcrumbElements[] = ['name' => $dossier->name, 'url' => $dossier->full_pathname];
                $dossier = $dossier->parent;
            }
        }

        $breadcrumbElements = array_reverse($breadcrumbElements);

        return view('Clinique::front.index', compact('cliniques', 'breadcrumbElements', 'page'));
    }
}
