<?php

/**
 * Created by IntelliJ IDEA.
 * User: loic
 * Date: 09/12/2020
 * Time: 10:47
 */

/** @var \Illuminate\Database\Eloquent\Factory $factory */

use Bloom\CMS\Core\Contenus\Statut;
use Bloom\CMS\HPV\Cliniques\Model\Clinique;
use Faker\Generator as Faker;
use Grimzy\LaravelMysqlSpatial\Types\Point;

$factory->define(Clinique::class, function (Faker $faker) {
    return [
        'nom'              => $faker->company,
        'adresse'          => $faker->address,
        'cp'               => $faker->postcode,
        'ville'            => $faker->city,
        'telephone'        => [['value' => $faker->phoneNumber, 'libelle' => $faker->text(10)]],
        'fax'              => $faker->phoneNumber,
        'doctolib'         => $faker->url,
        'vignette'         => $faker->imageUrl(),
        'transport'        => $faker->text,
        'description'      => $faker->text,
        'position'         => new Point($faker->latitude, $faker->longitude),
        'created_by'       => '1',
        'last_modified_by' => '1',
        'statut_id'        => Statut::PUBLIE,
    ];
});

$factory->state(Clinique::class, 'unpublished', ['statut_id' => Statut::EN_COURS]);
$factory->state(Clinique::class, 'publihsed', ['statut_id' => Statut::PUBLIE]);
$factory->state(Clinique::class, 'archived', ['statut_id' => Statut::ARCHIVE]);
