<?php

/**
 * Created by IntelliJ IDEA.
 * User: loic
 * Date: 07/12/2020
 * Time: 12:10
 */

namespace Tests\Feature;

use Bloom\CMS\Core\Contenus\Statut;
use Bloom\CMS\Core\Helpers\Workflow;
use Bloom\CMS\Core\Test;
use Bloom\CMS\HPV\Cliniques\CliniquesServiceProvider;
use Bloom\CMS\HPV\Cliniques\Model\Clinique;
use Grimzy\LaravelMysqlSpatial\Types\Point;
use Illuminate\Foundation\Auth\User;

class AdminCliniqueTest extends Test
{
    protected $provider = CliniquesServiceProvider::class;

    public function test_post_save_should_create_a_clinique()
    {
        /**
         * @var Clinique $clinique
         */
        $clinique = factory(Clinique::class)->make();

        $form = $clinique->toArray();
        /**
         * @var Point $point
         */
        $point = $form['position'];
        unset($form['position']);
        $form['point_lat'] = $point->getLat();
        $form['point_lng'] = $point->getLng();
        $form['values'] = json_encode($form['telephone']);
        unset($form['telephone']);

        $response = $this->actingAs(User::first())->post(route('admin_clinique_save'), $form);

        $expected = $clinique->makeHidden(['position', 'created_by', 'last_updated_by'])->toArray();
        $expected['telephone'] = json_encode($expected['telephone']);
        $response->assertRedirect(route('admin_clinique_index'));
        $this->assertDatabaseHas(
            'cliniques',
            $expected
        );
    }

    public function test_post_save_should_edit_a_clinique()
    {
        /**
         * @var Clinique $clinique
         */
        $clinique = factory(Clinique::class)->create();

        $form = $clinique->toArray();
        /**
         * @var Point $point
         */
        $point = $form['position'];
        unset($form['position']);
        $form['point_lat'] = $point->getLat();
        $form['point_lng'] = $point->getLng();

        $form['nom'] = "Clinique test";
        $form['values'] = json_encode($form['telephone']);
        unset($form['telephone']);

        $expected = $clinique->makeHidden(['position', 'created_by', 'last_updated_by', 'updated_at'])->toArray();
        $expected['nom'] = "Clinique test";
        $expected['telephone'] = json_encode($expected['telephone']);

        $response = $this->actingAs(User::first())->post(route('admin_clinique_save', $clinique), $form);

        $response->assertRedirect(route('admin_clinique_index'));
        $this->assertDatabaseHas(
            'cliniques',
            $expected
        );
    }

    public function statutProvider()
    {
        return [
            [
                Statut::PUBLIE,
                'CLINIQUE_PUB'
            ],
            [
                Statut::EN_COURS,
                'CLINIQUE_EN_COURS'
            ],
            [
                Statut::ARCHIVE,
                'CLINIQUE_ARCHIVED'
            ],
        ];
    }

    /**
     * @param int    $statut
     * @param string $route
     *
     * @dataProvider statutProvider
     */
    public function test_index_should_show_current_statut_only(int $statut, string $workflow)
    {
        // On force le boot du provider
        $provider = $this->app->getProvider(CliniquesServiceProvider::class);
        $provider->boot();
        $expected_workflow = Workflow::query()->where('code', '=', $workflow)->first();
        static::assertInstanceOf(Workflow::class, $expected_workflow);

        $expected = factory(Clinique::class, rand(1, 10))->create(['statut_id' => $statut]);
        // On ajoute des cliniques supprimer
        factory(Clinique::class, rand(1, 10))->create(['statut_id' => Statut::SUPPRIMER]);
        // On ajoute des cliniques pas du même statut que celui attendu
        factory(Clinique::class, rand(1, 10))
            ->create(['statut_id' => $statut === Statut::ARCHIVE ? Statut::PUBLIE : Statut::ARCHIVE]);

        $response = $this->actingAs(User::first())->get(route('admin_clinique_index', $expected_workflow));
        $response->assertOk();
        $response->assertViewIs('Core::admin.listing');

        $contents = $response->viewData('contents');

        static::assertEquals($expected->count(), $contents->count());
        foreach ($contents as $item) {
            static::assertEquals($statut, (int)$item->statut_id);
        }
    }
}
