<?php

/**
 * Created by IntelliJ IDEA.
 * User: loic
 * Date: 07/12/2020
 * Time: 11:42
 */

namespace Bloom\CMS\HPV\Cliniques;

use Bloom\CMS\Core\BloomProvider;
use Bloom\CMS\Core\Contenus\PageStatique;
use Bloom\CMS\Core\Contenus\Statut;
use Bloom\CMS\Core\Http\Page;
use Bloom\CMS\HPV\Cliniques\Http\Controllers\FrontController;
use Illuminate\Support\Facades\Schema;

class CliniquesServiceProvider extends BloomProvider
{
    protected $nom = "Cliniques";
    protected $code = "clinique";
    protected $icons = "?";

    public function boot()
    {
        parent::boot();
        if (
            Schema::hasTable('page_statiques')
            && !PageStatique::query()->where('controller', '=', FrontController::class . '@index')->exists()
        ) {
            $statique = new PageStatique(
                [
                    'display_type' => 'Cliniques',
                    'action'       => 'Gérer les cliniques',
                    'route'        => 'admin_clinique_index',
                    'controller'   => FrontController::class . '@index'
                ]
            );
            $statique->save();

            $page = new Page();
            $page->contenu()->associate($statique);
            $page->titre = "Cliniques";
            $page->meta_titre = "Cliniques";
            $page->slug = "cliniques";
            $page->pathname = "/cliniques";
            $page->meta_description = "";
            $page->intro = "<p>Intro de la page des Cliniques</p>";
            $page->meta_titre = "";
            $page->multiplicity = "1";
            $page->statut_id = Statut::PUBLIE;
            $page->save();
        }
    }
}
