<?php

/**
 * Created by IntelliJ IDEA.
 * User: loic
 * Date: 07/12/2020
 * Time: 12:09
 */

namespace Tests\Unit;

use Bloom\CMS\Core\Test;
use Bloom\CMS\HPV\Cliniques\CliniquesServiceProvider;
use Bloom\CMS\HPV\Cliniques\Model\Clinique;
use Grimzy\LaravelMysqlSpatial\Types\Point;

class CliniqueTest extends Test
{
    protected $provider = CliniquesServiceProvider::class;

    public function test_position_should_be_a_valid_point()
    {
        /**
         * @var Clinique $clinique
         */
        $clinique = factory(Clinique::class)->create();

        static::assertInstanceOf(Point::class, $clinique->position);
        static::assertIsFloat($clinique->position->getLat());
        static::assertIsFloat($clinique->position->getLng());
    }
}
