<?php

/**
 * Created by IntelliJ IDEA.
 * User: loic
 * Date: 07/12/2020
 * Time: 11:59
 */

namespace Bloom\CMS\HPV\Cliniques\Http\Controllers;

use Bloom\CMS\Core\Contenus\Statut;
use Bloom\CMS\Core\Helpers\Actions;
use Bloom\CMS\HPV\Cliniques\Model\Clinique;
use Bloom\CMS\HPV\Cliniques\Model\Telephone;
use Grimzy\LaravelMysqlSpatial\Types\Point;
use http\Env\Request;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\Log;

class AdminController extends Controller
{

    public function getSubMenu(): array
    {
        return [
            'sub_menu_items' => [
                [
                    'title'  => 'Publiés',
                    'href'   => route('admin_clinique_index'),
                    'number' => Clinique::published()->count(),
                    'active' => request()->route()->getName() === 'admin_clinique_index',
                ],
                [
                    'title'  => 'En cours de rédaction',
                    'href'   => route('admin_clinique_encours'),
                    'number' => Clinique::query()->where('statut_id', '=', Statut::EN_COURS)->count(),
                    'active' => request()->route()->getName() === 'admin_clinique_encours',
                ],
                [
                    'title'  => 'Archivés',
                    'href'   => route('admin_clinique_archived'),
                    'number' => Clinique::archived()->count(),
                    'active' => request()->route()->getName() === 'admin_clinique_archived',
                ],
            ]
        ];
    }

    public function getViewData(array $data): array
    {
        return array_merge($data, $this->getSubMenu());
    }

    public function getDefaultActions(string $publie, string $action): array
    {
        $actions = new Actions();
        $actions
            ->addAction('Modifier', 'admin_clinique_edit')
            ->addAction($publie, $action, 'bloomicon-admin-arrow-up-right')
            ->addNewTabAction('Prévisualiser', 'admin_clinique_preview');
        $sub_actions = new Actions('sub_actions');
        $sub_actions
            ->addAction('Dupliquer', 'admin_clinique_duplicate', 'bloomicon-admin-copy')
            ->addAction('Publier', 'admin_clinique_publish', 'bloomicon-admin-arrow-up-right')
            ->addAction('Archiver', 'admin_clinique_archive', 'bloomicon-admin-archive');

        return array_merge($actions->toArray(), $sub_actions->toArray());
    }

    public function index()
    {
        $cliniques = Clinique::query()->where('statut_id', '=', Statut::PUBLIE)->get();

        return view(
            'Clinique::admin.index',
            $this->getViewData(
                compact('cliniques') +
                $this->getDefaultActions('Dépublier', 'admin_clinique_unpublish')
            )
        );
    }

    public function encours()
    {
        $cliniques = Clinique::query()->where('statut_id', '=', Statut::EN_COURS)->get();

        return view(
            'Clinique::admin.index',
            $this->getViewData(
                compact('cliniques') +
                $this->getDefaultActions('Publier', 'admin_clinique_publish')
            )
        );
    }

    public function archived()
    {
        $cliniques = Clinique::query()->where('statut_id', '=', Statut::ARCHIVE)->get();
        $actions = new Actions();
        $actions
            ->addNewTabAction('Prévisualiser', 'admin_clinique_preview')
            ->addAction('Désarchiver', 'admin_clinique_unpublish');
        $sub_actions = new Actions('sub_actions');
        $sub_actions
            ->addAction('Supprimer', 'admin_clinique_delete', 'bloomicon-admin-trash-2');

        return view(
            'Clinique::admin.index',
            $this->getViewData(compact('cliniques') + $actions->toArray() + $sub_actions->toArray())
        );
    }

    public function edit(Clinique $clinique)
    {
        $telephones = [];

        if (!empty($clinique->telephone)) {
            $telephones = $this->checkTelephonesIsEmpty($clinique->telephone);
        } else {
            $telephone['libelle'] = '';
            $telephone['value'] = '';
            $telephones[] = $telephone;
        }

        $clinique->telephone = $telephones;

        return view('Clinique::admin.edit', compact('clinique'));
    }

    public function checkTelephonesIsEmpty(array $telephones): array
    {
        $newTelephones = [];

        foreach ($telephones as $telephone) {
            if ($telephone['libelle'] != '') {
                $newTelephones[] = $telephone;
            }
        }
        return $newTelephones;
    }

    public function save(Clinique $clinique)
    {
        $clinique->nom = request('nom');
        $clinique->adresse = request('adresse');
        $clinique->cp = request('cp');
        $clinique->ville = request('ville');
        $clinique->telephone = $this->checkTelephonesIsEmpty(json_decode(request('values', '[]'), true));
        $clinique->fax = request('fax', '');
        $clinique->doctolib = request('doctolib');
        $clinique->vignette = request('vignette');
        $clinique->transport = request('transport');
        $clinique->description = request('description');
        $clinique->position = new Point(request('point_lat'), request('point_lng'));
        $clinique->statut_id = request('statut_id', Statut::EN_COURS);
        $clinique->save();

        if ((int)$clinique->statut_id === Statut::PUBLIE) {
            return redirect()->route('admin_clinique_index');
        }

        return redirect()->route('admin_clinique_encours');
    }

    //#region Actions

    public function preview(Clinique $clinique)
    {
        Log::debug("Loading clinique preview", compact('clinique'));
        $cliniques = Clinique::query()->whereIn('statut_id', [Statut::PUBLIE, Statut::EN_COURS])->get();

        return view('Clinique::front.index', compact('cliniques'));
    }

    public function duplicate(Clinique $clinique)
    {
        $dub = $clinique->replicate(['created_at', 'updated_at', 'created_by', 'last_modified_by']);
        $dub->nom = $clinique->nom . ' - Copie';
        $dub->save();

        return redirect()->back();
    }

    public function publish(Clinique $clinique)
    {
        $clinique->statut_id = Statut::PUBLIE;
        $clinique->to_publish_at = now();
        $clinique->save();

        return redirect()->back();
    }

    public function unpublish(Clinique $clinique)
    {
        $clinique->statut_id = Statut::EN_COURS;
        $clinique->to_unpublish_at = now();
        $clinique->save();

        return redirect()->back();
    }

    public function archive(Clinique $clinique)
    {
        $clinique->statut_id = Statut::ARCHIVE;
        $clinique->to_unpublish_at = now();
        $clinique->save();

        return redirect()->back();
    }

    public function delete(Clinique $clinique)
    {
        $clinique->statut_id = Statut::SUPPRIMER;
        $clinique->save();

        return redirect()->back();
    }
    //#endregion
}
