<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

/**
 * Created by IntelliJ IDEA.
 * User: loic
 * Date: 08/12/2020
 * Time: 16:53
 */
class AddCliniquesTable extends Migration
{
    public function up()
    {
        Schema::create('cliniques', function (Blueprint $table) {
            $table->id();
            $table->string('nom');
            $table->string('adresse');
            $table->string('cp');
            $table->string('ville');
            $table->string('telephone');
            $table->string('fax');
            $table->string('doctolib');
            $table->string('vignette');
            $table->text('transport');
            $table->text('description');
            $table->point('position');
            $table->unsignedBigInteger('created_by');
            $table->unsignedBigInteger('last_modified_by');
            $table->date('to_publish_at')->nullable()->default(null);
            $table->date('to_unpublish_at')->nullable()->default(null);
            $table->unsignedTinyInteger('statut_id');
            $table->timestamps();

            $table->foreign(['created_by'])->on('users')->references('id');
            $table->foreign(['last_modified_by'])->on('users')->references('id');
        });
    }

    public function down()
    {
        Schema::dropIfExists('cliniques');
    }
}
