<?php

/**
 * Created by IntelliJ IDEA.
 * User: loic
 * Date: 09/12/2020
 * Time: 12:33
 */

namespace Bloom\CMS\HPV\Cliniques\Spatial\Eloquent;

use Bloom\CMS\HPV\Cliniques\Spatial\SpatialExpression;
use Grimzy\LaravelMysqlSpatial\Types\GeometryInterface;
use Illuminate\Database\Eloquent\Builder as EloquentBuilder;

class Builder extends EloquentBuilder
{
    public function update(array $values)
    {
        foreach ($values as $key => &$value) {
            if ($value instanceof GeometryInterface) {
                $value = $this->asWKT($value);
            }
        }

        return parent::update($values);
    }

    protected function asWKT(GeometryInterface $geometry)
    {
        return new SpatialExpression($geometry);
    }
}
