<?php

/**
 * Created by IntelliJ IDEA.
 * User: loic
 * Date: 08/12/2020
 * Time: 17:09
 */

namespace Bloom\CMS\HPV\Cliniques\Model;

use Bloom\CMS\Core\Contenus\HasStatut;
use Bloom\CMS\Core\Contenus\IsUserTracked;
use Bloom\CMS\Core\Http\Page;
use Bloom\CMS\HPV\Cliniques\Spatial\SpatialTrait;
use Carbon\Carbon;
use Grimzy\LaravelMysqlSpatial\Types\Point;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Foundation\Auth\User;
use Illuminate\Support\Facades\Auth;

/**
 * Class Clinique
 *
 * @package Bloom\CMS\HPV\Cliniques\Model
 *
 * @property string $nom
 * @property string $adresse
 * @property string $cp
 * @property string $ville
 * @property string $telephone
 * @property string $fax
 * @property string $doctolib
 * @property string $vignette
 * @property string $transport
 * @property string $description
 * @property Point  $position
 * @property int    $id
 * @property int    $created_by
 * @property int    $last_modified_by
 * @property Carbon $to_publish_at
 * @property Carbon $to_unpublish_at
 *
 *    Computed
 *
 * @property User   $cree_par
 * @property User   $deriere_modification_par
 *
 * @property Page   $page
 */
class Clinique extends Model
{
    use IsUserTracked;
    use SpatialTrait;
    use HasStatut;

    protected $spatialFields = [
        'position',
    ];

    protected $casts = [
        'to_publish_at'   => 'date',
        'to_unpublish_at' => 'date',
        'telephone'       => 'array',
    ];

    public static function boot()
    {
        parent::boot();
        static::saving(
            function (Clinique $clinique) {
                if (Auth::check()) {
                    if (!$clinique->exists) {
                        $clinique->created_by = Auth::user()->getAuthIdentifier();
                    }
                    $clinique->last_modified_by = Auth::user()->getAuthIdentifier();
                }
            }
        );
    }
}
