<?php

namespace Bloom\CMS\HPV\Cliniques\Http\Events\Handler;

use Bloom\CMS\Core\Contenus\Statut;
use Bloom\CMS\HPV\Cliniques\Http\Events\CliniqueArchived;
use Bloom\CMS\HPV\Cliniques\Http\Events\CliniqueDeleted;
use Bloom\CMS\HPV\Cliniques\Http\Events\CliniquePublished;
use Bloom\CMS\HPV\Cliniques\Http\Events\CliniqueUnpublished;
use Bloom\CMS\HPV\Cliniques\Model\Clinique;
use Illuminate\Support\Facades\Event;

class CliniqueHandler
{
    public function saving(Clinique $page)
    {
        if (!$page->exists) {
            // Si la page n'existe pas, il s'agit d'une nouvelle page et donc
            // aucune redirection n'est à écrire ni aucun evenement de changement de statut
            return;
        }

        if ($page->isDirty('statut_id')) {
            // On trigger les events de publication / dépublication de page
            switch ((int)$page->statut_id) {
                case Statut::SUPPRIMER:
                    Event::dispatch(new CliniqueDeleted($page));
                    break;
                case Statut::ARCHIVE:
                    Event::dispatch(new CliniqueArchived($page));
                    break;
                case Statut::EN_COURS:
                    if ($page->getOriginal('statut_id') == Statut::PUBLIE) {
                        Event::dispatch(new CliniqueUnpublished($page));
                    }
                    break;
                case Statut::PUBLIE:
                    Event::dispatch(new CliniquePublished($page));
            }
        }
    }
}
