<?php

/**
 * Created by IntelliJ IDEA.
 * User: loic
 * Date: 07/12/2020
 * Time: 11:42
 */

namespace Bloom\CMS\HPV\Cliniques;

use Bloom\CMS\Core\BloomProvider;
use Bloom\CMS\Core\Contenus\PageStatique;
use Bloom\CMS\Core\Contenus\Statut;
use Bloom\CMS\Core\Helpers\Actions;
use Bloom\CMS\Core\Helpers\TableHeader;
use Bloom\CMS\Core\Helpers\WorkflowsFactory;
use Bloom\CMS\Core\Http\Page;
use Bloom\CMS\HPV\Cliniques\Http\Controllers\FrontController;
use Bloom\CMS\HPV\Cliniques\Http\Events\Subscriber\CliniqueSubscriber;
use Bloom\CMS\HPV\Cliniques\Model\Clinique;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\Event;

class CliniquesServiceProvider extends BloomProvider
{
    protected $nom = "Cliniques";
    protected $code = "clinique";
    protected $icons = "?";

    public function register()
    {
        parent::register();
        Event::subscribe(CliniqueSubscriber::class);
    }

    public function boot()
    {
        parent::boot();
        if (
            Schema::hasTable('page_statiques')
            && !PageStatique::query()->where('controller', '=', FrontController::class . '@index')->exists()
        ) {
            $statique = new PageStatique(
                [
                    'display_type' => 'Cliniques',
                    'action'       => 'Gérer les cliniques',
                    'route'        => 'admin_clinique_index',
                    'controller'   => FrontController::class . '@index'
                ]
            );
            $statique->save();

            $page = new Page();
            $page->contenu()->associate($statique);
            $page->titre = "Cliniques";
            $page->meta_titre = "Cliniques";
            $page->slug = "cliniques";
            $page->pathname = "/cliniques";
            $page->meta_description = "";
            $page->intro = "<p>Intro de la page des Cliniques</p>";
            $page->meta_titre = "";
            $page->multiplicity = "1";
            $page->statut_id = Statut::PUBLIE;
            $page->save();
        }
        $factory = new WorkflowsFactory(Clinique::class);
        $this->declarePublishedWorkflow($factory);
        $this->declareEnCoursWorkflow($factory);
        $this->declareArchivedWorkflow($factory);
        $this->haveGenericIndex($factory);
    }

    public function declarePublishedWorkflow(WorkflowsFactory $factory)
    {
        $factory
            //#region CLINIQUE_PUB
            ->add('Publiées', "CLINIQUE_PUB")
            ->statement("SELECT * FROM cliniques WHERE statut_id = " . Statut::PUBLIE)
            ->edition('admin_clinique_edit', 'Créer une clinique')
            ->setAction(
                (new Actions())
                    ->addAction('Modifier', 'admin_clinique_edit')
                    ->addNewTabAction('Prévisualiser', 'admin_clinique_preview')
            )->setSubActions(
                (new Actions())
                    ->addAction('Dupliquer', 'admin_clinique_duplicate', 'bloomicon-admin-copy')
                    ->addAction('Dépublier', 'admin_clinique_unpublish', 'bloomicon-admin-arrow-down-left')
                    ->addAction('Archiver', 'admin_clinique_archive', 'bloomicon-admin-archive')
            )->setHeaders(
                [
                    (new TableHeader('Vignette', 'page.image_opengraph'))->isImage(),
                    (new TableHeader('Id', 'id'))->canOrder(),
                    (new TableHeader('Titre', 'nom'))->canOrder(),
                    (new TableHeader('Créé le', 'created_at'))->canOrder()->haveTitle('page.cree_par.name'),
                    (new TableHeader('Modifié le', 'updated_at'))
                        ->canOrder()->haveTitle('page.derniere_modification_par.name'),
                    (new TableHeader('Dates de<br> publication', 'to_publish_at'))->canOrder(),
                ]
            )
            ->push();
        //#endregion
    }

    public function declareEnCoursWorkflow(WorkflowsFactory $factory)
    {
        $factory
            //#region CLINIQUE_EN_COURS
            ->add('En cours de rédaction', "CLINIQUE_EN_COURS")
            ->statement("SELECT * FROM cliniques WHERE statut_id = " . Statut::EN_COURS . "
                                ORDER BY cliniques.updated_at DESC")
            ->edition('admin_clinique_edit', 'Créer une clinique')
            ->setAction(
                (new Actions())
                    ->addAction('Modifier', 'admin_clinique_edit')
                    ->addNewTabAction('Prévisualiser', 'admin_clinique_preview')
            )->setSubActions(
                (new Actions())
                    ->addAction('Dupliquer', 'admin_clinique_duplicate', 'bloomicon-admin-copy')
                    ->addAction('Publier', 'admin_clinique_publish', 'bloomicon-admin-arrow-up-right')
                    ->addAction('Archiver', 'admin_clinique_archive', 'bloomicon-admin-archive')
            )->setHeaders(
                [
                    (new TableHeader('Vignette', 'page.image_opengraph'))->isImage(),
                    (new TableHeader('Id', 'id'))->canOrder(),
                    (new TableHeader('Titre', 'nom'))->canOrder(),
                    (new TableHeader('Créé le', 'created_at'))->canOrder()->haveTitle('page.cree_par.name'),
                    (new TableHeader('Modifié le', 'updated_at'))
                        ->canOrder()->haveTitle('page.derniere_modification_par.name'),
                    (new TableHeader('Dates de<br> publication', 'to_publish_at'))->canOrder(),
                ]
            )
            ->push();
        //#endregion
    }

    public function declareArchivedWorkflow($factory)
    {
        $factory
            //#region CLINIQUE_ARCHIVED
            ->add('Archivées', "CLINIQUE_ARCHIVED")
            ->statement("SELECT * FROM cliniques WHERE statut_id = " . Statut::ARCHIVE . "
                            ORDER BY cliniques.updated_at DESC")
            ->edition('admin_clinique_edit', 'Créer une clinique')
            ->setAction(
                (new Actions())
                    ->addAction('Désarchiver', 'admin_clinique_unpublish')
                    ->addAction('Supprimer', 'admin_clinique_delete')
            )->setSubActions(
                (new Actions())
                    ->addAction('Dupliquer', 'admin_clinique_duplicate', 'bloomicon-admin-copy')
            )->setHeaders(
                [
                    (new TableHeader('Vignette', 'page.image_opengraph'))->isImage(),
                    (new TableHeader('Id', 'id'))->canOrder(),
                    (new TableHeader('Titre', 'nom'))->canOrder(),
                    (new TableHeader('Créé le', 'created_at'))->canOrder()->haveTitle('page.cree_par.name'),
                    (new TableHeader('Modifié le', 'updated_at'))
                        ->canOrder()->haveTitle('page.derniere_modification_par.name'),
                    (new TableHeader('Dates de<br> publication', 'to_publish_at'))->canOrder(),
                ]
            )
            ->push();
        //#endregion
    }
}
