<?php
/**
 * Created by : loic
 * Created at : 21/04/2020
 *
 * In : IntelliJ IDEA
 */

namespace Bloom\CMS\Modules\Articles;

use Bloom\CMS\Modules\Architecture\Model\Module;
use Bloom\CMS\Modules\Architecture\Model\Page;
use Bloom\CMS\Modules\Articles\Http\Middleware\ModuleMiddleware;
use Bloom\CMS\Modules\Articles\Model\Article;
use Illuminate\Database\Eloquent\Relations\Relation;
use Illuminate\Support\Facades\Route;
use Illuminate\Support\Facades\Schema;

class CmsArticlesServiceProvider extends \Illuminate\Support\ServiceProvider
{

    public function register(): void
    {
        $this->loadFactoriesFrom(dirname(__DIR__) . '/database/factories');
        $this->loadMigrationsFrom(dirname(__DIR__) . '/database/migrations');
        $this->loadViewsFrom(dirname(__DIR__) . '/resources/views', 'Articles');
        $dirname = dirname(__DIR__) . '/routes';
        foreach (scandir($dirname) as $file) {
            if (!in_array($file, ['.', '..'])) {
                Route::group(['middleware' => ['web', ModuleMiddleware::class]], function () use ($dirname, $file) {
                    $this->loadRoutesFrom($dirname . '/' . $file);
                });
            }
        }

        $this->publishes([
            dirname(__DIR__) . '/public' => public_path('/vendor/cms-module-articles')
        ], 'assets');
    }

    public static function getModule()
    {
        if (Schema::hasTable('modules')) {
            $module = Module::nom('article')->firstOrCreate([
                'nom'        => 'article',
                'nom_public' => 'Articles',
                'route'      => 'admin_article_index',
            ]);
            if(!$module->exists) {
                $module->active = 1;
                $module->save();
            }
            return $module;
        }

        return false;
    }

    public function boot(): void
    {

        // Déclaration contenu
        Relation::morphMap([
            'articles' => Article::class,
        ]);
        Page::declareContenu('articles');
        self::getModule();
    }

}