<?php
/**
 * Created by IntelliJ IDEA.
 * User: loic
 * Date: 03/03/20
 * Time: 14:56
 */

namespace Tests;


use Bloom\CMS\Modules\Architecture\CmsArchiServiceProvider;
use Bloom\CMS\Modules\Articles\CmsArticlesServiceProvider;
use Illuminate\Foundation\Testing\DatabaseMigrations;
use Illuminate\Foundation\Testing\DatabaseTransactions;
use Illuminate\Foundation\Testing\RefreshDatabase;
use Illuminate\View\Factory;
use Orchestra\Testbench\TestCase;
use TwigBridge\Facade\Twig;
use TwigBridge\ServiceProvider;

class Test extends TestCase
{

    use RefreshDatabase;

    protected function getPackageProviders($app)
    {
        return [ServiceProvider::class, CmsArchiServiceProvider::class, CmsArticlesServiceProvider::class];
    }

    protected function getPackageAliases($app)
    {
        return [
            'Twig' => Twig::class
        ];
    }

    /**
     * Setup the test environment.
     */
    protected function setUp(): void
    {
        parent::setUp();
        $this->loadLaravelMigrations('sqlite');
        // On doit charger a la main les migrations archi
        $this->loadMigrationsFrom(dirname(__DIR__) . '/vendor/bloom/cms-module-archi/database/migrations');
        $this->loadMigrationsFrom(dirname(__DIR__) . '/database/testings/migrations');
        // and other test setup steps you need to perform
        $this->loadMigrationsFrom(dirname(__DIR__) . '/database/testings/migrations');
        $this->seed(\StatutSeeder::class);
    }

    protected function getEnvironmentSetUp($app)
    {
        $app['config']->set('database.connections.sqlite', [
            'driver'   => 'sqlite',
            'database' => dirname(__DIR__) . '/database/database.sqlite',
            'prefix'   => '',
        ]);
        $app['config']->set('database.default', 'testing');
        $app['config']->set('filesystems.disks.local.root', dirname(__DIR__).'/storage');
        $app['config']->set('filesystems.disks.images.driver', 'local');
        $app['config']->set('filesystems.disks.images.root', dirname(__DIR__).'/storage/images');
        $app['config']->set('app.admin', 'admin');
        $app['config']->set('logging.default', 'stack');
        $app['config']->set('logging.channels.single.path', dirname(__DIR__) . '/logs/laravel.log');
        $app->afterResolving('view', function ($view) {
            /**
             * @var Factory $view
             */
            $view->addNamespace('Bloom', dirname(__DIR__) . '/resources/views_testing');
        });
    }
}