<?php

/**
 * Created by : loic
 * Created at : 21/04/2020
 *
 * In : IntelliJ IDEA
 */

namespace Bloom\CMS\Modules\Articles;

use Bloom\CMS\Core\BloomProvider;
use Bloom\CMS\Core\Http\Page;
use Bloom\CMS\Modules\Articles\Model\Article;
use Illuminate\Database\Eloquent\Relations\Relation;

class CmsArticlesServiceProvider extends BloomProvider
{
    protected $nom = "Articles";
    protected $code = "article";
    protected $icons = "file-text";

    public function boot(): void
    {
        parent::boot();

        // Déclaration contenu
        Relation::morphMap([
            'articles' => Article::class,
        ]);
        Page::declareContenu('articles');
    }
}
