<?php
/**
 * Created by : loic
 * Created at : 21/04/2020
 *
 * In : IntelliJ IDEA
 */

namespace Bloom\CMS\Modules\Articles\Model;

use Bloom\CMS\Modules\Architecture\Http\Controllers\ContenuHandler;
use Bloom\CMS\Modules\Architecture\Model\Contenu;
use Bloom\CMS\Modules\Architecture\Model\Page;
use Carbon\Carbon;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Http\Response;


/**
 * Class Article
 * @package Bloom\CMS\Modules\Articles\Model
 *
 *
 * @property string            contenu
 * @property Page[]|Collection page
 *
 * @method static Builder|static published()
 * @method static Builder|static archived()
 * @method static Builder|static programmed()
 * @method static Builder|static notProgrammed()
 * @method static Builder|static programmedFor(Carbon $date)
 * @method static Builder|static status(int $status)
 */
class Article extends Model implements Contenu
{
    public function page(): BelongsTo
    {
        return $this->belongsTo(Page::class);
    }

    public function getHandler(): ContenuHandler
    {
        return new class implements ContenuHandler {

            public function single(Contenu $contenu): Response
            {
                /**
                 * @var Page $page
                 */
                $page = $contenu->page;
                $breadcrumbElements = [["name" => $page->titre, 'url' => $page->pathname]];
                if ($page->dossier) {
                    $dossier = $page->dossier;
                    while ($dossier !== null) {
                        $breadcrumbElements[] = ['name' => $dossier->name, 'url' => $dossier->full_pathname];
                        $dossier = $dossier->parent;
                    }
                }

                $breadcrumbElements = array_reverse($breadcrumbElements);

                return response(view('Articles::front.index', ['article' => $contenu, 'page' => $page, 'breadcrumbElements' => $breadcrumbElements]));
            }

            public function multiple(Collection $contenus): Response
            {
                // TODO: Implement multiple() method.
            }

            public function ensemble()
            {
                // TODO: Implement ensemble() method.
            }
        };
    }

    public function scopePublished(Builder $query)
    {
        return $this->scopeStatus($query, 1);
    }


    public function scopeArchived(Builder $query)
    {
        return $this->scopeStatus($query, 0);
    }

    public function scopeStatus(Builder $query, int $status)
    {
        return $query->whereHas('page', function (Builder $query) use ($status) {
            return $query->where('statut_id', '=', $status);
        });
    }

    public function scopeProgrammed(Builder $query)
    {
        return $query->whereHas('page', function (Builder $query) {
            return $query->whereNotNull('to_publish_at')
                ->where('statut_id', '=', 2);
        });
    }

    public function scopeNotProgrammed(Builder $query)
    {
        return $query->whereHas('page', function (Builder $query) {
            return $query->whereNull('to_publish_at');
        });
    }

}