<?php

namespace Bloom\CMS\Modules\Articles\Views\Components;

use Closure;
use Illuminate\Contracts\View\View;
use Illuminate\View\Component;

class DossiersOptions extends Component
{
    /**
     * The input dossiers
     *
     * @var array
     */
    public $dossiers;

    /**
     * The input article_id
     *
     * @var numeric
     */
    public $dossier_id;

    /**
     * Create the component instance.
     *
     * @param  array  $class
     * @param  integer  $article_id
     * @return void
     */

    /**
     * Create a new component instance.
     *
     * @return void
     */
    public function __construct($dossiers, $dossier_id = null)
    {
        $this->dossiers = $dossiers;
        $this->dossier_id = $dossier_id;
    }

    /**
     * Get the view / contents that represent the component.
     */
    public function render(): View|Closure|string
    {
        return view('Article::components.dossiers-options');
    }
}
