<?php

/**
 * Created by : loic
 * Created at : 21/04/2020
 *
 * In : IntelliJ IDEA
 */

namespace Bloom\CMS\Modules\Articles;

use Bloom\CMS\Core\BloomProvider;
use Bloom\CMS\Core\Contenus\Statut;
use Bloom\CMS\Core\Http\Page;
use Bloom\CMS\Core\Helpers\Actions;
use Bloom\CMS\Core\Helpers\TableHeader;
use Bloom\CMS\Core\Helpers\WorkflowsFactory;
use Bloom\CMS\Modules\Articles\Model\Article;
use Illuminate\Database\Eloquent\Relations\Relation;

class CmsArticlesServiceProvider extends BloomProvider
{
    protected $nom = "Articles";
    protected $code = "article";
    protected $icons = "file-text";

    public function boot(): void
    {
        parent::boot();

        // Déclaration contenu
        Relation::morphMap([
            'articles' => Article::class,
        ]);
        Page::declareContenu('articles');

        $factory = new WorkflowsFactory(Article::class);
        $this->declarePublishedWorkflow($factory);
        $this->declareProgrammedWorkflow($factory);
        $this->declareEnCoursWorkflow($factory);
        $this->declareArchivedWorkflow($factory);
        $this->haveGenericIndex($factory);

        $this->publishes([
            dirname(__DIR__) . '/public/build' => public_path('/vendor/cms-module-article')
        ], 'assets');
    }

    public function declarePublishedWorkflow($factory)
    {
        $factory
        //#region ARTICLE_PUB
        ->add('Publiés', "ARTICLE_PUB")
        ->statement("SELECT articles.*
                                    FROM articles
                                    JOIN pages ON articles.id = pages.contenu_id AND pages.contenu_type = 'articles'
                                    WHERE pages.statut_id = " . Statut::PUBLIE)
        ->edition('admin_article_edit', 'Créer un article')
        ->setAction(
            (new Actions())
                ->addAction('Modifier', 'admin_article_edit')
                ->addNewTabAction('Prévisualiser', 'admin_article_preview')
        )->setSubActions(
            (new Actions())
                ->addAction('Dupliquer', 'admin_article_duplicate', 'bloomicon-admin-copy')
                ->addAction('Dépublier', 'admin_article_unpublish', 'bloomicon-admin-arrow-down-left')
                ->addAction('Archiver', 'admin_article_archive', 'bloomicon-admin-archive')
        )->setHeaders(
            [
                (new TableHeader('Vignette', 'page.image_opengraph'))->isImage(),
                (new TableHeader('Id', 'id'))->canOrder(),
                (new TableHeader('Titre', 'page.titre'))->canOrder(),
                (new TableHeader('Chemin archi', 'page.pathname')),
                (new TableHeader('Créé le', 'created_at'))->canOrder()->haveTitle('page.cree_par.name'),
                (new TableHeader('Modifié le', 'updated_at'))
                    ->canOrder()->haveTitle('page.derniere_modification_par.name'),
                (new TableHeader('Dates de<br> publication', 'page.to_publish_at'))->canOrder(),
            ]
        )
        ->push();
                //#endregion
    }

    public function declareProgrammedWorkflow($factory)
    {
        $factory
        //#region ARTICLE_PROGRAMMED
        ->add('Programmés', "ARTICLE_PROGRAMMED")
            ->statement("SELECT articles.*
                            FROM articles
                            JOIN pages ON articles.id = pages.contenu_id AND pages.contenu_type = 'articles'
                            WHERE pages.statut_id = " . Statut::EN_COURS . " AND pages.to_publish_at IS NOT NULL
                            ORDER BY pages.to_publish_at DESC")
            ->edition('admin_article_edit', 'Créer un article')
            ->setAction(
                (new Actions())
                    ->addAction('Modifier', 'admin_article_edit')
                    ->addNewTabAction('Prévisualiser', 'admin_article_preview')
            )->setSubActions(
                (new Actions())
                    ->addAction('Dupliquer', 'admin_article_duplicate', 'bloomicon-admin-copy')
                    ->addAction('Publier', 'admin_article_publish', 'bloomicon-admin-arrow-up-right')
                    ->addAction('Archiver', 'admin_article_archive', 'bloomicon-admin-archive')
            )->setHeaders(
                [
                    (new TableHeader('Vignette', 'page.image_opengraph'))->isImage(),
                    (new TableHeader('Id', 'id'))->canOrder(),
                    (new TableHeader('Titre', 'page.titre'))->canOrder(),
                    (new TableHeader('Chemin archi', 'page.pathname')),
                    (new TableHeader('Créé le', 'created_at'))->canOrder()->haveTitle('page.cree_par.name'),
                    (new TableHeader('Modifié le', 'updated_at'))
                        ->canOrder()->haveTitle('page.derniere_modification_par.name'),
                    (new TableHeader('Dates de<br> publication', 'page.to_publish_at'))->canOrder(),
                ]
            )
            ->push();
        //#endregion
    }

    public function declareEnCoursWorkflow($factory)
    {
        $factory
        //#region ARTICLE_EN_COURS
        ->add('En cours de rédaction', "ARTICLE_EN_COURS")
        ->statement("SELECT articles.*
                                FROM articles
                                JOIN pages ON articles.id = pages.contenu_id AND pages.contenu_type = 'articles'
                                WHERE pages.statut_id = " . Statut::EN_COURS . " AND pages.to_publish_at IS NULL
                                ORDER BY updated_at DESC")
        ->edition('admin_article_edit', 'Créer un article')
        ->setAction(
            (new Actions())
                ->addAction('Modifier', 'admin_article_edit')
                ->addNewTabAction('Prévisualiser', 'admin_article_preview')
        )->setSubActions(
            (new Actions())
                ->addAction('Dupliquer', 'admin_article_duplicate', 'bloomicon-admin-copy')
                ->addAction('Publier', 'admin_article_publish', 'bloomicon-admin-arrow-up-right')
                ->addAction('Archiver', 'admin_article_archive', 'bloomicon-admin-archive')
        )->setHeaders(
            [
                (new TableHeader('Vignette', 'page.image_opengraph'))->isImage(),
                (new TableHeader('Id', 'id'))->canOrder(),
                (new TableHeader('Titre', 'page.titre'))->canOrder(),
                (new TableHeader('Chemin archi', 'page.pathname')),
                (new TableHeader('Créé le', 'created_at'))->canOrder()->haveTitle('page.cree_par.name'),
                (new TableHeader('Modifié le', 'updated_at'))
                    ->canOrder()->haveTitle('page.derniere_modification_par.name'),
                (new TableHeader('Dates de<br> publication', 'page.to_publish_at'))->canOrder(),
            ]
        )
        ->push();
        //#endregion
    }

    public function declareArchivedWorkflow($factory)
    {
        $factory
        //#region ARTICLE_ARCHIVED
        ->add('Archivés', "ARTICLE_ARCHIVED")
        ->statement("SELECT articles.*
                                FROM articles
                                JOIN pages ON articles.id = pages.contenu_id AND pages.contenu_type = 'articles'
                                WHERE pages.statut_id = " . Statut::ARCHIVE . "
                                ORDER BY updated_at DESC")
        ->edition('admin_article_edit', 'Créer un article')
        ->setAction(
            (new Actions())
                ->addAction('Désarchiver', 'admin_article_unpublish')
                ->addAction('Supprimer', 'admin_article_delete')
        )->setSubActions(
            (new Actions())
                ->addAction('Dupliquer', 'admin_article_duplicate', 'bloomicon-admin-copy')
        )->setHeaders(
            [
                (new TableHeader('Vignette', 'page.image_opengraph'))->isImage(),
                (new TableHeader('Id', 'id'))->canOrder(),
                (new TableHeader('Titre', 'page.titre'))->canOrder(),
                (new TableHeader('Chemin archi', 'page.pathname')),
                (new TableHeader('Créé le', 'created_at'))->canOrder()->haveTitle('page.cree_par.name'),
                (new TableHeader('Modifié le', 'updated_at'))
                    ->canOrder()->haveTitle('page.derniere_modification_par.name'),
                (new TableHeader('Dates de<br> publication', 'page.to_publish_at'))->canOrder(),
            ]
        )
        ->push();
        //#endregion
    }
}
