@extends('bloom.layout.admin')

@section('bodyClass', 'page-edit')

@section('assets')
    @vite('resources/js/form.js', 'vendor/cms-module-article')
    @vite('resources/js/multisites.js','vendor/cms-module-article')
    <script src="/plugins/ckeditor/ckeditor.js"></script>
    <script type="text/javascript" src="/js/ckfinder/ckfinder.js"></script>
    <script>CKFinder.config({connectorPath: '/ckfinder/connector'});</script>
@endsection

@section('content')
    <div class="container-fluid">
        <div id="navbar-btns" class="mb-5 heading-text d-flex justify-content-between align-items-center sticky-top">
            <h1>{{ $article->exists() ? 'Éditer' : 'Créer' }} un article</h1>

            <span class="wrapper-btns ml-auto">
                <a href="{{ route('admin_article_index') }}" class="btn-annuler btn btn-grisclair5 btn-primary">
                    Annuler
                </a>
                <a href="javascript:void(0);" class="btn-valider submit btn btn-grisclair5 btn-primary"
                   onclick="$('.main form').submit()">
                    Valider
                </a>
                <a href="javascript:void(0);" class="btn-publier submit btn btn-grisclair5 btn-primary"
                   onclick="publishAndSubmit()">
                    Valider et publier
                </a>
                <a href="@if($article->exists()) {{ route('admin_article_preview', $article) }} @else javascript:void(0); @endif"
                   target="_blank"
                   class="btn-previsualier btn btn-grisclair5 btn-primary @if(!($article->exists())) disabled @endif"
                   title="@if(!($article->exists())) Sauvegarder pour prévisualiser @endif">
                    Prévisualiser
                </a>
            </span>
        </div>

        <div class="content">
            <form action=" {{ route('admin_article_save', $article) }} " method="POST" id="form">
                <div class="form-group row mb-0">
                    <div class="col-6 mb-4">
                        <x-forms.input-text
                                name="titre"
                                text="Titre"
                                form="admin"
                                :value="$page->titre"
                        />
                    </div>
                    <div class="col-6 mb-4">
                        <x-forms.input-text
                                name="slug"
                                text="Slug"
                                form="admin"
                                :value="$page->slug"
                        />
                    </div>
                    <div class="col-12 mb-4">
                        <div class="wrapper-editor">
                            <x-forms.editor
                                    name="intro"
                                    text="Introduction <em>(facultatif)</em>"
                                    :value="$page->intro"
                                    form="admin"
                                    format="mini"
                            />
                        </div>
                    </div>
                    <div class="col-12 mb-4">
                        <div class="wrapper-editor">
                            <x-forms.editor
                                    name="contenu"
                                    text="Contenu"
                                    :value="$article->contenu"
                                    form="admin"
                            />
                        </div>
                    </div>
                </div>

                <div class="form-group mb-0">
                    <div class="mb-4">
                        <div class="wrapper-editor">
                            <x-forms.editor
                                    name="mentions"
                                    text="Mentions <em>(facultatif)</em>"
                                    :value="$page->mentions"
                                    form="admin"
                                    format="mini"
                            />
                        </div>
                    </div>
                </div>

                <div class="form-group row mb-0">
                    <div class="col-12 mb-4">
                        <div class="row">
                            <div class="col-6">
                                <select class="form-control" name="dossier_id" id="dossier_id">
                                    @if(!isset($path_restrict))
                                        <option value="">Localisation dans l'architecture</option>
                                    @endif
                                    <x-dossiers-options
                                            :dossiers="$dossiers"
                                            :dossier_id="$page->$dossier_id"
                                    />
                                </select>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="form-group mb-4">
                    <label class="control-label" for="date_pub">Dates de publication</label>

                    <div class="row w-75">
                        {{--{{ field.calendrier('articles', 'date_pub', 'date_depub', page) }}--}}
                    </div>
                </div>

                <div class="form-group mb-4">
                    <label for="vignette" class="control-label">Vignette</label>
                    <x-forms.input-custom-file-with-image
                            name="vignette"
                            text="Parcourir"
                            form="admin"
                            :required="$page->image_opengraph === ''"
                            :value="$page->image_opengraph"
                    />
                </div>

                @if(!(is_empty($sites)))
                    <div class="form-group mb-4">
                        <label for="vignette" class="control-label">Liste des sites disponibles</label>
                        @if(count($sites) > 1)
                            <div class="custom-control custom-checkbox select-all-div">
                                <input type="checkbox" name="select-all-sites" class="custom-control-input"
                                       id="select-all-sites"
                                       checked
                                >
                                <label class="custom-control-label" for="select-all-sites">
                                    Tout sélectionner / désélectionner
                                </label>
                            </div>
                        @endif
                        @foreach($sites as $site)
                            <div class="custom-control custom-checkbox">
                                <input type="checkbox" value="{{ $site->id }}" name="multisite[]"
                                       class="custom-control-input site-checkbox"
                                       id="site{{ $site->id }}"
                                       @if($page->exists())
                                           @foreach($site_pages as $site_page)
                                               {{ $site_page->id == $site->id?'checked':'' }}
                                           @endforeach
                                       @else
                                           checked
                                       @endif
                                       @if(auth_user()->getAccessLevel() > 1)
                                           required
                                        @endif
                                >
                                <label class="custom-control-label"
                                       for="site{{ $site->id }}">{{ $site->domaine_public }}</label>
                            </div>
                        @endforeach
                    </div>
                @endif

                <input type="hidden" name="statut_id" value="{{ $page->statut_id }}">
                {{ csrf_field() }}
            </form>
        </div>
    </div>
@endsection