<?php

namespace App\View\Components;

use Closure;
use Illuminate\Contracts\View\View;
use Illuminate\View\Component;

class Loader extends Component
{
    /**
     * The input dossiers
     *
     * @var array
     */
    public $dossiers;

    /**
     * The input article_id
     *
     * @var numeric
     */
    public $article_id;

    /**
     * Create the component instance.
     *
     * @param  array  $class
     * @param  integer  $article_id
     * @return void
     */

    /**
     * Create a new component instance.
     *
     * @return void
     */
    public function __construct($dossiers, $article_id)
    {
        $this->dossiers = $dossiers;
        $this->article_id = $article_id;
    }

    /**
     * Get the view / contents that represent the component.
     */
    public function render(): View|Closure|string
    {
        return view('components.dossiers-options');
    }
}
