<?php
/**
 * Created by : loic
 * Created at : 21/04/2020
 *
 * In : IntelliJ IDEA
 */

use Illuminate\Support\Facades\Route;

Route::group(['prefix' => config('app.admin'), 'middleware' => ['auth'], 'namespace' => 'Bloom\CMS\Modules\Articles\Http\Controllers'], function () {
    Route::group(['prefix' => 'articles'], function () {
        Route::get('/', 'AdminController@index')->name('admin_article_index');
        Route::get('/programmed', 'AdminController@programmed')->name('admin_article_programmes');
        Route::get('/encours', 'AdminController@encours')->name('admin_article_encours');
        Route::get('/archived', 'AdminController@archived')->name('admin_article_archived');
        Route::get('/edit/{article?}', 'AdminController@edit')->name('admin_article_edit');
        Route::post('/edit/{article?}', 'AdminController@save')->name('admin_article_save');
        Route::get('/{article}/preview', 'AdminController@preview')->name('admin_article_preview');
        Route::get('/{article}/publish', 'AdminController@publish')->name('admin_article_publish');
        Route::get('/{article}/unpublish', 'AdminController@unpublish')->name('admin_article_unpublish');
        Route::get('/{article}/archive', 'AdminController@archive')->name('admin_article_archive');
        Route::get('/{article}/duplicate', 'AdminController@duplicate')->name('admin_article_duplicate');
        Route::get('/{article}/delete', 'AdminController@delete')->name('admin_article_delete');
    });
});