<?php

use Bloom\CMS\Modules\Architecture\Model\Page;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class ArticleMorph extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        $articles = \Bloom\CMS\Modules\Articles\Model\Article::all();
        Schema::table('articles', function (Blueprint $table) {
            $table->dropColumn('page_id');
        });
        foreach ($articles as $article) {
            /**
             * @var Page $page
             */
            $page = Page::find($article->page_id);
            if ($page) {
                $page->contenu()->associate($article);
                $page->save();
            }
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('articles', function (Blueprint $table) {
            $table->integer('page_id', false, true);
        });
    }
}
