export default class Section {
    set type(value) {
        if (value === 'lien') {
            this.info = new SectionLien();
        } else {
            this.info = new SectionDossier();
        }
        this._type = value;
    }

    get type() {
        return this._type;
    }

    constructor(rang = 0) {
        this.type = 'lien';
        this.info = new SectionLien;
        this.titre = 'Section ' + rang;
        this.rang = rang;

        function uuid() {
            return 'xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx'.replace(/[xy]/g, function(c) {
                let r = Math.random() * 16 | 0, v = c === 'x' ? r : (r & 0x3 | 0x8);
                return v.toString(16);
            });
        }

        this.id = uuid();
    }
}

class SectionLien {
    constructor() {
        this.description = '';
        this.cta = '';
        this.cta_bg = '';
        this.cta_color = '';
        this.page_id = '';
    }
}

class SectionDossier {
    constructor() {
        this.dossier_id = '';
    }
}